#ifndef MBED_TRACKBALL_H
#define MBED_TRACKBALL_H


#include "mbed.h"

#define dir_UP 1
#define dir_DOWN 2
#define dir_LEFT 3
#define dir_RIGHT 4
#define dir_BUTTON 5
#define color_WHITE 1
#define color_RED 2
#define color_GREEN 3
#define color_BLUE 4

//Setup a new class for a Trackball Module
class Trackball
{
public:
    Trackball(PinName pin_btn, PinName pin_lft, PinName pin_rht, PinName pin_up, PinName pin_dwn, PinName pin_wht, PinName pin_grn, PinName pin_red, PinName pin_blu);
    unsigned int read(int dir);
    void write(unsigned int val, int color);
private:
//class sets up the pins
    DigitalIn _pin_btn;
    DigitalIn _pin_lft;
    DigitalIn _pin_rht;
    DigitalIn _pin_up;
    DigitalIn _pin_dwn;
    DigitalOut _pin_wht;
    DigitalOut _pin_grn;
    DigitalOut _pin_red;
    DigitalOut _pin_blu;
};

#endif