#include "mbed.h"
#include "Trackball.h"

//set up the trackball

Trackball trackball(p12, p13, p14, p15, p16, p17, p18, p19, p20);

//for prints to serial port
Serial pc(USBTX, USBRX);


int main() {
    
    //turn on each LED individually for 2 seconds each
    trackball.write(1, color_WHITE);
    wait(2);
    trackball.write(0, color_WHITE);
    trackball.write(1, color_BLUE);
    wait(2);
    trackball.write(0, color_BLUE);
    trackball.write(1, color_GREEN);
    wait(2);
    trackball.write(0, color_GREEN);
    trackball.write(1, color_RED);
    wait(2);
    trackball.write(0, color_RED);

    //positioning data
    int x = 0;
    int y = 0;
    //keeping track of changes in movement
    unsigned int old_up = 1;
    unsigned int new_up = 1;
    unsigned int old_down = 1;
    unsigned int new_down = 1;
    unsigned int old_right = 1;
    unsigned int new_right = 1;
    unsigned int old_left = 1;
    unsigned int new_left = 1;
    
    
    while(1) {


//comparing old val to new val makes sure to only register changes to the value as movement
    new_up = trackball.read(dir_UP);
    new_down = trackball.read(dir_DOWN);
    new_left = trackball.read(dir_LEFT);
    new_right = trackball.read(dir_RIGHT);
 
        if((new_up == 0) && (old_up == 1)){
            trackball.write(1, color_BLUE);
            trackball.write(0, color_WHITE);
            trackball.write(0, color_GREEN);
            trackball.write(0, color_RED);
            y++;
            }
        if((new_down == 0) && (old_down == 1)){
            trackball.write(1, color_GREEN);
            trackball.write(0, color_WHITE);
            trackball.write(0, color_BLUE);
            trackball.write(0, color_RED);
            y--;
            }
        if((new_left == 0) && (old_left == 1)){
            
            trackball.write(1, color_WHITE);
            trackball.write(0, color_GREEN);
            trackball.write(0, color_BLUE);
            trackball.write(0, color_RED);
            x--;
            }
        if((new_right == 0) && (old_right == 1)){
            trackball.write(1, color_RED);
            trackball.write(0, color_WHITE);
            trackball.write(0, color_GREEN);
            trackball.write(0, color_BLUE);
            x++;  
            }
        if(trackball.read(dir_BUTTON) == 0){
            trackball.write(1, color_RED);
            trackball.write(1, color_BLUE);
            trackball.write(1, color_GREEN);
            trackball.write(1, color_WHITE);
            }
            
            pc.printf("X: %d, Y: %d\n", x, y);
            
            //keep track of these now old vals to compare to the future to see changes
            old_up = new_up;
            old_down = new_down;
            old_left = new_left;
            old_right = new_right;
            
            
            wait(.2);
    
            
    }
}
