#include "mbed.h"
#include "Trackball.h"

//set up the trackball

Trackball trackball(p12, p13, p14, p15, p16, p17, p18, p19, p20);
Serial pc(USBTX, USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int main() {
    
//initial LED testing
//turn on each color for 2 seconds
    
    trackball.write(1, color_WHITE);
    wait(2);
    trackball.write(0, color_WHITE);
    trackball.write(1, color_BLUE);
    wait(2);
    trackball.write(0, color_BLUE);
    trackball.write(1, color_GREEN);
    wait(2);
    trackball.write(0, color_GREEN);
    trackball.write(1, color_RED);
    wait(2);
    trackball.write(0, color_RED);

int x_pos = 0;
int y_pos = 0;
  
    while(1) {
        //read the pins
        //if LFT,RHT,UP,DWN,or BTN are 0
        //write out to the colored LEDs
        //keep track of x and y positions
        //wait .2
        
        //make sure to turn off all other color LEDS when turning on a new one.
        //keeping the writes inside the if statements prevents flashing of the LED if it is already on and needs to stay on.
 
        if(trackball.read(dir_UP) == 0){
            y_pos++;
            trackball.write(1, color_WHITE);
            trackball.write(0, color_GREEN);
            trackball.write(0, color_BLUE);
            trackball.write(0, color_RED);
            }
        else if(trackball.read(dir_DOWN) == 0){
            y_pos--;
            trackball.write(1, color_GREEN);
            trackball.write(0, color_WHITE);
            trackball.write(0, color_BLUE);
            trackball.write(0, color_RED);
            }
        else if(trackball.read(dir_LEFT) == 0){
            x_pos--;
            trackball.write(1, color_BLUE);
            trackball.write(0, color_WHITE);
            trackball.write(0, color_GREEN);
            trackball.write(0, color_RED);
            }
        else if(trackball.read(dir_RIGHT) == 0){
            x_pos++;
            trackball.write(1, color_RED);
            trackball.write(0, color_WHITE);
            trackball.write(0, color_GREEN);
            trackball.write(0, color_BLUE);
            }
        else if(trackball.read(dir_BUTTON) == 0){
            pc.printf("Button pressed.");
            }
        pc.printf("X pos: %d, Y pos: %d\n", x_pos, y_pos);  
        wait(.2);
    }
}
