// ESP8266 Static page WEB server to control Mbed

/* ----------------------------------------------------------------------
* Copyright (C) 2010-2012 ARM Limited. All rights reserved.
*
* $Date:         17. January 2013
* $Revision:     V1.4.0
*
* Project:       CMSIS DSP Library
* Title:         arm_fft_bin_example_f32.c
*
* Description:   Example code demonstrating calculation of Max energy bin of
*                frequency domain of input signal.
*
* Target Processor: Cortex-M4/Cortex-M3
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*   - Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
*   - Redistributions in binary form must reproduce the above copyright
*     notice, this list of conditions and the following disclaimer in
*     the documentation and/or other materials provided with the
*     distribution.
*   - Neither the name of ARM LIMITED nor the names of its contributors
*     may be used to endorse or promote products derived from this
*     software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
* COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
* ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
 * -------------------------------------------------------------------- */

#include "mbed.h"
#include "XNucleo53L0A1.h"
#include "uLCD_4DGL.h"
#include <stdio.h>

#include "mbed-dsp/cmsis_dsp/arm_math.h"
#include "mbed-dsp/cmsis_dsp/arm_const_structs.h"

#define TEST_LENGTH_SAMPLES 1024
//Ticker to control microphone interrupt
Ticker ticker;
//FFT output
float32_t testOutput[TEST_LENGTH_SAMPLES/2];
//Microphone
AnalogIn   a_in(p16);
//Serial Out to PC for debug
Serial pc(USBTX, USBRX);
//Signal for fft
float32_t testInput_f32_10khz[1024];
//uint32_t counter = 0;
arm_status status = ARM_MATH_SUCCESS;
//Max valued FFT bin
float32_t maxValue;
/* ------------------------------------------------------------------
* Global variables for FFT Bin Example
* ------------------------------------------------------------------- */
uint32_t refIndex = 213, testIndex = 0;
uint32_t fftSize = 512;
uint32_t ifftFlag = 0;
uint32_t doBitReverse = 1;


DigitalIn pb(p7);

Serial esp(p13, p14); // tx, rx

// Lidar
DigitalOut shdn(p26);
//I2C sensor pins
#define VL53L0_I2C_SDA   p28
#define VL53L0_I2C_SCL   p27
static XNucleo53L0A1 *board=NULL;

// Standard Mbed LED definitions
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
DigitalOut  led3(LED3);
DigitalOut  led4(LED4);

Timer gameTimer;
Timer restartGame;

char ssid[32] = "Test123";     // enter WiFi router ssid inside the quotes
char pwd [32] = "joe12345"; // enter WiFi router password inside the quotes

//Declare Game variables Here ~~~~~~~~~~~~~~~~~~~~`
//Used to keep track of top 5 players. if scoreCurrent is > score1[1} then score[1]
//is shifted to the next and so forth 
float score1 = 0, score2 = 0, score3 = 0, score4 = 0, score5 = 0;
float scoreBuffer = 0;
float scoreCurrent = 0;

char score1Char[10];
char score2Char[10];
char score3Char[10];
char score4Char[10];
char score5Char[10];


// things for sending/receiving data over serial
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
const int buffer_size = 4095;
char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];
void Tx_interrupt();
void Rx_interrupt();
void send_line();
void read_line();

int DataRX;
int update;
int count;
char cmdbuff[1024];
char replybuff[4096];
char webdata[4096]; // This may need to be bigger depending on WEB browser used
char webbuff[4096];     // Currently using 1986 characters, Increase this if more web page data added
char timebuf[30];
void SendCMD(),getreply(),ReadWebData(),startserver();
void gettime(),setRTC(), getScore1(), getScore2(), getScore3(), getScore4(), getScore5();
char rx_line[1024];
int port        =80;  // set server port
int SERVtimeout =5;    // set server timeout in seconds in case link breaks.
struct tm t;
// manual set RTC values
int minute      =00;    // 0-59
int hour        =12;    // 2-23
int dayofmonth  =26;    // 1-31
int month       =8;     // 1-12
int year        =15;    // last 2 digits

bool gameIsRunning = false;

DigitalOut led_1(LED1);
DigitalOut led_2(LED2);

void init_uLCD() {
//    uLCD.baudrate(3000000);
}

void get_fft() {
    /* Process the data through the CFFT/CIFFT module */
    arm_cfft_f32(&arm_cfft_sR_f32_len512, testInput_f32_10khz, ifftFlag, doBitReverse);
    /* Process the data through the Complex Magnitude Module for
    calculating the magnitude at each bin */
    arm_cmplx_mag_f32(testInput_f32_10khz, testOutput, fftSize);
    /* Calculates maxValue and returns corresponding BIN value */
    testOutput[0] = 0;
    arm_max_f32(testOutput, fftSize, &maxValue, &testIndex);
    //pc.printf("\n\rMax Value: %f\n\rAt bin: %i\n\r",maxValue,testIndex);
    if(gameIsRunning) {
        if(testIndex >= 180 && testIndex <= 200) {
            scoreCurrent += 1;
            led2 = 1;
            pc.printf("Current score is %f !!! \r\n", scoreCurrent);
            pc.printf("The current game time is %f seconds!\r\n", gameTimer.read());
        }
    }
    //Arrays have to be cleared for multiple FFT calculations
    for (int i = 0; i < 1024; i++) {
        testInput_f32_10khz[i] = 0;
    }
    for (int i = 0; i < 512; i++) {
        testOutput[i] = 0;
    }    
}

void get_signal()
{
    //Begin sampling when microphone picks up loud sound
    led2 = 0;
    if (a_in > 0.6 || a_in < 0.4){
        for(int i = 0; i < 1024; i += 2) {
            testInput_f32_10khz[i] = a_in.read();
        } 
        get_fft();
        wait(1.0/100.0); 
    }     
}


int main()
{
    
    int status;
    uint32_t distance;
    DevI2C *device_i2c = new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);
    /* creates the 53L0A1 expansion board singleton obj */
    board = XNucleo53L0A1::instance(device_i2c, A2, D8, D2);
    shdn = 0; //must reset sensor for an mbed reset to work
    wait(0.1);
    shdn = 1;
    wait(0.1);
    /* init the 53L0A1 board with default values */
    status = board->init_board();
    while (status) {
            pc.printf("Failed to init board! \r\n");
            status = board->init_board();
            } // Failed to init Lidar Sensor
    
    // Setup a serial interrupt function to receive data
    esp.attach(&Rx_interrupt, Serial::RxIrq);
    // Setup a serial interrupt function to transmit data
    esp.attach(&Tx_interrupt, Serial::TxIrq);
    if (time(NULL) < 1420070400) {
        setRTC();
    }
    
    // Initialize microphone code
    for (int i = 0; i < 1024; i++) {
        testInput_f32_10khz[i] = 0;
    }
    ticker.attach(&get_signal, 2.0/100.0); 
    
    //Check that the LCD Works Statement
    // uLCD.locate(1,1);
    //uLCD.printf("Hello from LCD screen");
    
    //Start the server
    startserver();
    DataRX=0;
    count=0;
    
    while(1){
    
    pc.baud(9600);
    esp.baud(9600);
    
    // Handle the pushbutton
    pb.mode(PullUp);
    int old_pb = 0;
    int new_pb;
    
    pc.printf("Welcome to the Loop on a Rope Game!\r\n");
    wait(1);
    pc.printf("Please press the pushbutton to start the game!\r\n");
    
    gameTimer.reset();
    gameTimer.stop();
    
    scoreCurrent = 0;
    while(gameTimer.read() < 70){
        new_pb = pb;
        if ((new_pb==0) && (old_pb==1)){
            
            //while(1){
                gameIsRunning = true;
                pc.printf("\nGame Begins NOW! You have 120 seconds\r\n");
                                
                //loop taking and printing distance
                //gameTimer.start(); // old game timer start
                //float extraTime = gameTimer.read();
                //pc.printf("Did we make it here? \r\n");
                gameTimer.start();
                while (gameTimer.read() < 60) {
                    //pc.printf("Did we make it here? x 2 \r\n");
                    status = board->sensor_centre->get_distance(&distance);
                    if (status == VL53L0X_ERROR_NONE) {
                        if (distance < 200){
                            led_1 = 1;
                            pc.printf("D=%ld mm\r\n", distance);
                            wait(1.5);
                            status = board->sensor_centre->get_distance(&distance);
                            if (status == VL53L0X_ERROR_NONE) {
                                if (distance < 200) {
                                    pc.printf("Congrats, You hooked it! Please Remove The hook ASAP to ensure a fair score!\r\n");
                                    scoreCurrent = scoreCurrent + 10;
                                    pc.printf("Current score is %f !!! \r\n", scoreCurrent);
                                    pc.printf("The current game time is %f seconds! You only have 120 seconds!\r\n", gameTimer.read());
                                    //wait(4);
                                    gameTimer.stop();
                                    gameIsRunning = false;
                                    while(distance < 200){
                                        status = board->sensor_centre->get_distance(&distance);
                                    }
                                    gameTimer.start();
                                    gameIsRunning = true;
                                } //If distance is still greater than 100
                                led_1 = 0;
                            }
                        } // If distance > 100 end 
                        //else {
                          //  pc.printf("Please retry to hook it ASAP!\r\n");
                            //pc.printf("The current game time is %f seconds! Remember, you only have 120 seconds!\r\n", gameTimer.read());
                            //wait(4);
                        //} //else statement for 
                    } //if statement for using the LIDAR with no error
                } //While gameTimer < 120 end
            //} //Second while(1) loop end
        } //if statement end with pushbutton
        old_pb = new_pb;
        //gameTimer.reset();
    }  //final while(1) loop    
    
    old_pb = 0;
    gameTimer.stop();
    gameIsRunning = false;
    
    pc.printf("Congrats, your final score was %f ! \r\n", scoreCurrent);
    
    wait(1);
    
    if (scoreCurrent > score1){
        scoreBuffer = score1;
        score1 = scoreCurrent;
        score5 = score4;
        score4 = score3;
        score3 = score2;
        score2 = scoreBuffer;
        pc.printf("Congrats on placing 1/5 on the High Scores! \r\n");
        }   else if (scoreCurrent > score2){
        scoreBuffer = score2;
        score5 = score4;
        score4 = score3;
        score3 = scoreBuffer;
        score2 = scoreCurrent;
        pc.printf("Congrats on placing 2/5 on the High Scores! \r\n");
        }   else if (scoreCurrent > score3){
        scoreBuffer = score3;
        score5 = score4;
        score4 = scoreBuffer;;
        score3 = scoreCurrent;
        pc.printf("Congrats on placing 3/5 on the High Scores! \r\n");
        }   else if (scoreCurrent > score4){
        scoreBuffer = score4;
        score5 = scoreBuffer;
        score4 = scoreCurrent;
        pc.printf("Congrats on placing 4/5 on the High Scores! \r\n");
        }   else if (scoreCurrent > score5){
            scoreBuffer = score5;
            score5 = scoreCurrent;
            pc.printf("Congrats on placing 5/5 on the High Scores! \r\n");
        }   else {
            pc.printf("Sorry, you didn't make it on the HighScores! Please check 172.20.10.3 to view the table! \r\n");
            }
    
    wait(5);
    
//    while(1) {
        if(DataRX==1) {
            ReadWebData();
            esp.attach(&Rx_interrupt, Serial::RxIrq);
        }
        if(update==1) // update time, hit count, and analog levels in the HUZZAH chip
        {
            // get new values
            gettime();
            getScore1();
            getScore2();
            getScore3();
            getScore4();
            getScore5();
            count++;
            // send new values
            sprintf(cmdbuff, "score1read,score2read,score3read,score4read,score5read = \"%s\",\"%s\",\"%s\",\"%s\",\"%s\"\r\n", score1Char,score2Char,score3Char,score4Char,score5Char);
            SendCMD();
            getreply();
            update=0;   
        }
//    }
    }
}
// END OF MAIN HERE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Reads and processes GET and POST web data
void ReadWebData()
{
    wait_ms(200);
    esp.attach(NULL,Serial::RxIrq);
    DataRX=0;
    memset(webdata, '\0', sizeof(webdata));
    strcpy(webdata, rx_buffer);
    memset(rx_buffer, '\0', sizeof(rx_buffer));
    rx_in = 0;
    rx_out = 0;
    // check web data for form information
    if( strstr(webdata, "check=led1v") != NULL ) {
        led1=!led1;
    }
    if( strstr(webdata, "check=led2v") != NULL ) {
        led2=!led2;
    }
    if( strstr(webdata, "check=led3v") != NULL ) {
        led3=!led3;
    }
    if( strstr(webdata, "check=led4v") != NULL ) {
        led4=!led4;
    }
    if( strstr(webdata, "POST") != NULL ) { // set update flag if POST request
        update=1;
    }
    if( strstr(webdata, "GET") != NULL && strstr(webdata, "favicon") == NULL ) { // set update flag for GET request but do not want to update for favicon requests
        update=1;
    }
}
// Starts webserver
void startserver()
{
    gettime();
    getScore1();
    getScore2();
    getScore3();
    getScore4();
    getScore5();
    pc.printf("++++++++++ Resetting ESP ++++++++++\r\n");
    strcpy(cmdbuff,"node.restart()\r\n");
    SendCMD();
    wait(2);
    getreply();
    
    pc.printf("\n++++++++++ Starting Server ++++++++++\r\n> ");

    // initial values
    sprintf(cmdbuff, "score1read,score2read,score3read,score4read,score5read = \"%s\",\"%s\",\"%s\",\"%s\",\"%s\"\r\n", score1Char,score2Char,score3Char,score4Char,score5Char);
    SendCMD();
    getreply();
    wait(0.5);

    //create server
    sprintf(cmdbuff, "srv=net.createServer(net.TCP,%d)\r\n",SERVtimeout);
    SendCMD();
    getreply();
    wait(0.5);
    strcpy(cmdbuff,"srv:listen(80,function(conn)\r\n");
    SendCMD();
    getreply();
    wait(0.3);
        strcpy(cmdbuff,"conn:on(\"receive\",function(conn,payload) \r\n");
        SendCMD();
        getreply();
        wait(0.3);
        
        //print data to mbed
        strcpy(cmdbuff,"print(payload)\r\n");
        SendCMD();
        getreply();
        wait(0.2);
       
        //web page data CODE FOR TABLE FOUND HERE
        strcpy(cmdbuff,"conn:send('<!DOCTYPE html><html><head><style>body { background-color:#D6DBDF; color: blue; font: 12px arial, verdana; }')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('table {border-collapse: collapse;}')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('th {text-align: center; border: 4px solid; background-color: #e2dee5; font-size: 18px;}')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('td {text-align: center; border: 2px dashed; padding: 5px; height: 15px; font-size: 14px}')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('tr:nth-child(even) {background-color: #D5F5E3;}tr:nth-child(odd) {background-color: ##ABEBC6;} tr:hover {background-color: #b0bff4;}</style></head>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('<body><h2 align=\"center\"><font size=\"5\">Loop on a Rope Highscores</font></h2>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('<br><table border=\"1\" style=\"width:100%\"><tr><th>Rank</th><th>High Score</th></tr><br><hr>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('<tr><td>1</td><td> '..score1read..' </td></tr>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('<tr><td>2</td><td> '..score2read..' </td></tr>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('<tr><td>3</td><td> '..score3read..' </td></tr>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('<tr><td>4</td><td> '..score4read..' </td></tr>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('<tr><td>5</td><td> '..score5read..' </td></tr></table>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('<form method=\"POST\"')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff,"conn:send('<p><input type=\"submit\" value=\"send-refresh\"></form>')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        
        // end web page data
        
        strcpy(cmdbuff, "conn:on(\"sent\",function(conn) conn:close() end)\r\n"); // close current connection
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "end)\r\n");
        SendCMD();
        getreply();
        wait(0.2);
    strcpy(cmdbuff, "end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);

    strcpy(cmdbuff, "tmr.alarm(0, 1000, 1, function()\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "if wifi.sta.getip() == nil then\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "print(\"Connecting to AP...\\n\")\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "else\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "ip, nm, gw=wifi.sta.getip()\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"print(\"IP Address: \",ip)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"tmr.stop(0)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    
    pc.printf("\n\n++++++++++ Ready ++++++++++\r\n\n");
}


// ESP Command data send
void SendCMD()
{
    int i;
    char temp_char;
    bool empty;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    empty = (tx_in == tx_out);
    while ((i==0) || (cmdbuff[i-1] != '\n')) {
// Wait if buffer full
        if (((tx_in + 1) % buffer_size) == tx_out) {
// End Critical Section - need to let interrupt routine empty buffer by sending
            NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % buffer_size) == tx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = cmdbuff[i];
        i++;
        tx_in = (tx_in + 1) % buffer_size;
    }
    if (esp.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % buffer_size;
// Send first character to start tx interrupts, if stopped
        esp.putc(temp_char);
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return;
}

// Get Command and ESP status replies
void getreply()
{
    read_line();
    sscanf(rx_line,replybuff);
}
 
// Read a line from the large rx buffer from rx interrupt routine
void read_line() {
    int i;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
// Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\r')) {
// Wait if buffer empty
        if (rx_in == rx_out) {
// End Critical Section - need to allow rx interrupt to get new characters for buffer
            NVIC_EnableIRQ(UART1_IRQn);
            while (rx_in == rx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    rx_line[i-1] = 0;
    return;
}
 
 
// Interupt Routine to read in data from serial port
void Rx_interrupt() {
    DataRX=1;
    //led3=1;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((esp.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = esp.getc();
// Uncomment to Echo to USB serial to watch data flow
        pc.putc(rx_buffer[rx_in]);
        rx_in = (rx_in + 1) % buffer_size;
    }
    //led3=0;
    return;
}
 
 
// Interupt Routine to write out data to serial port
void Tx_interrupt() {
    //led2=1;
// Loop to fill more than one character in UART's transmit FIFO buffer
// Stop if buffer empty
    while ((esp.writeable()) && (tx_in != tx_out)) {
        esp.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % buffer_size;
    }
    //led2=0;
    return;
}

void gettime()
{
    time_t seconds = time(NULL);
    strftime(timebuf,50,"%H:%M:%S %a %d %b %y", localtime(&seconds));
}

void setRTC()
{
    t.tm_sec = (0);             // 0-59
    t.tm_min = (minute);        // 0-59
    t.tm_hour = (hour);         // 0-23
    t.tm_mday = (dayofmonth);   // 1-31
    t.tm_mon = (month-1);       // 0-11  "0" = Jan, -1 added for Mbed RCT clock format
    t.tm_year = ((year)+100);   // year since 1900,  current DCF year + 100 + 1900 = correct year
    set_time(mktime(&t));       // set RTC clock
}

void getScore1()
{
    sprintf(score1Char,"%2.3f",score1);   
}
void getScore2()
{
    sprintf(score2Char,"%2.3f",score2);   
}
void getScore3()
{
    sprintf(score3Char,"%2.3f",score3);   
}
void getScore4()
{
    sprintf(score4Char,"%2.3f",score4);   
}
void getScore5()
{
    sprintf(score5Char,"%2.3f",score5);   
}