/*
 * TC77 SPI Thermal Sensor
 *
 *   mbed                       TC77
 *  pin5 MOSI ---R 10K---+
 *                       |
 *  pin6 MISO -----------+--- pin1 SI/O
 *
 *  pin7 SCK   -------------- pin2 SCK
 *
 *  pin8 CS    -------------- pin7 CS(active low)
 *
 *
 */

#include "mbed.h"
#include "TC77.h"

//トラ技ARMライタではPCとの通信でUSBシリアルを使うにはUSBDeviceライブラリが必要
#ifdef TARGET_LPC11U35_501
#include "USBSerial.h"
USBSerial pc;
#else
Serial pc(USBTX,USBRX);
#endif

SPI spi1(p5,p6,p7);
TC77 tc77(&spi1, p8);

int main() {
    tc77.start();
    while(true) {
        pc.printf("%.1f \r\n",tc77.temperature());
        wait(1.0);
        //pc.printf("%x\r\n",tc77.id());
        //wait(1.0);
    }
}
