#include "mbed.h"
#include "SDFileSystem.h"
#include "YconP020.h"
#include <string>
#include <vector>
#include <queue>

//このプログラムは YconP020ライブラリの使い方の例も含んでいます。
//使用例を取り除いて純粋に「USB-UART変換器＋コマンド拡張」として
//使う場合は以下の #define を 0 に設定してください。
#define SAMPLECODE 1

#ifdef TARGET_LPC11U35_501
//トラ技ARMライタではPCとの通信にUSBシリアルを使うにはUSBDeviceライブラリが必要
#include "USBSerial.h"
USBSerial pc;
#define USE_USBSerial
#else
Serial pc(USBTX,USBRX);
#endif

#if DEVICE_LOCALFILESYSTEM == 1
LocalFileSystem localFS("MBED");
#endif
SDFileSystem sdcard(p5, p6, p7, p8, "sd");

YconP020 epd(p9, p10);

DigitalOut ledcommode(LED1);

queue<char> pcrecbuf;
void pcint() {
    //mbed1768 だとここは if で良いのだけど
    //トラ技ARMライタでは whileにしないとうまく行かない
    //USBSerialだと1文字毎には割り込みは入らないのかな？
    //mbed1768なら whileでもうまく行くので whileを使った
    while(pc.readable()) pcrecbuf.push(pc.getc());
}

void epdtopc() {
    while(epd.readable()) pc.putc(epd.getc());
}

int main() {
#ifndef USE_USBSerial
    pc.baud(115200);
#endif
    pc.attach(pcint);
    pc.puts("\r\nY-Con P020 Extend mode by mbed\r\n");
#if SAMPLECODE == 1
    //こんな使い方も出来ますよという例
    //例1 epd.printf()でコマンドを実行する
    epd.command_mode();
    epd.printf("d %d\r", 3);
    epdtopc();
    epd.wait_command_ready();
    wait(2);
    //例2 メンバ関数でコマンドを実行する
    pc.printf("%s", epd.yslab_info().c_str());
    //例3 epd.text() を使って文字を表示する
    epd.text()->cls();
    epd.setfontscale(2,3);
    epd.text()->puts("Hello World\n");
    epd.setfontscale(1,2);
    epd.text()->puts("YconP020 ");
    epd.setfontscale(1,3);
    epd.text()->printf("LED: %d ", epd.command_led());
    epd.command_led(false);
    epd.text()->printf("%d ", epd.command_led());
    epd.command_led(!epd.command_led());
    epd.text()->printf("%d\n", epd.command_led());
    epd.command_interval(2560);
    epd.text()->printf("Interval=%d\n",epd.command_interval());
    epd.command_interval(3000);
    epd.display_internalbuf();
    wait(3);
    //例4 epd.pset() でグラフィック表示
    epd.clear_internalbuf();
    for(int x=0; x<epd.width(); x++) {
        epd.pset(x,(sin(2*3.14/200*x)+1)*epd.height()/2);
        epd.pset(x,epd.height()/2);
    }
    epd.display_internalbuf();
    wait(1);
    //例5 グラフィックをクリアせずに重ねて文字表示
    epd.text()->puts("Display Graphics\nand Text at\nthe same time\n");
    epd.display_internalbuf();
#endif //SAMPLECODE==1
    while(1) {
        ledcommode = epd.command_ready();
        __disable_irq();
        while(!pcrecbuf.empty() && !pc.readable()) {
            char c=pcrecbuf.front();
            pcrecbuf.pop();
            __enable_irq();
            epd.putc(c);
            __disable_irq();
        }
        __enable_irq();
        if(epd.readable()) {
            pc.putc(epd.getc());
        }
    }
}
