//#define AKIDUKI_I2CPIC

#include "mbed.h"
#include "TextLCD_ostream.h"
#include <iomanip>
 
#ifdef TARGET_MBED_LPC1768
I2C i2c(p28,p27); // SDA, SCL
#else
I2C i2c(I2C_SDA, I2C_SCL);
#endif

#ifdef AKIDUKI_I2CPIC
//秋月 PIC搭載I2C 16x2
#include "ACM1602NI.h"
ACM1602NI lcd(i2c);
TextLCD_ostream<ACM1602NI> lcds(&lcd);
#else
#include "TextLCD.h"
//マルツ MI2CLCD-01 I2C 16x2+icon
//ストロベリーリナックス I2C 16x2+icon
//秋月 小型I2C 16x2
TextLCD_I2C_N lcd(&i2c);
const int LCDCONTRAST=32;
//秋月 超小型I2C 8x2
//TextLCD_I2C_N lcd(&i2c, ST7032_SA, TextLCD::LCD8x2);
//const int LCDCONTRAST=20;

//lcd_ostream lcds(&lcd);
TextLCD_ostream<TextLCD_I2C_N> lcds(&lcd);
#endif

int main() {
    using namespace std;
    #if(LCD_CONTRAST == 1)
    // lcds.lcd() で元の TextLCDにアクセス出来る
    lcds.lcd().setContrast(LCDCONTRAST);
    #endif
    while(true) {
        // lcds.cls() は TextLCD_ostream& を返すので、そこにそのまま << 出来る
        // endl で次の行の先頭に行く
        lcds.cls() << "Hello world" << endl << "LCD ostream";
        wait(2);
        lcds.cls();
        for(int i=0; i<6; i++) {
            //最下行で endl すると1行目に移動する
            lcds << "line:" << i << endl;
            wait(1);
        }
        lcds.cls() << 10L << ',' << setw(4) << 3.14f << endl << "count: ";
        for(int i=3; i>=0; i--) {
            // locate() も cls()と同様に続けて << 出来る
            lcds.locate(8,1) << i;
            wait(1);
        }
        wait(2);
    }
}
