#ifndef TEXTLCD_OSTREAM_H
#define TEXTLCD_OSTREAM_H

#include <ostream>
#include <streambuf>

/** ostream wrapper for TextLCD.
LCDCLASS(TextLCD) need to have putc(),locate(),cls() function.
@code
#include "mbed.h"
#include "TextLCD.h"
#include "TextLCD_ostream.h"
 
I2C i2c(p28,p27); // SDA, SCL
TextLCD_I2C_N lcd(&i2c, ST7032_SA, TextLCD::LCD16x2, NC, TextLCD::ST7032_3V3);
TextLCD_ostream<TextLCD_I2C_N> lcdstream(&lcd);

int main() {
    using namespace std;
    lcd.setContrast(32);
    lcdstream.cls() << "Hello world" << endl << "LCD ostream";
}
@endcode
 */
template <class LCDCLASS>
class TextLCD_ostream : public std::ostream {
public:
    /// @param p pointer to object of LCD class
    TextLCD_ostream(LCDCLASS *p)
      : std::ostream(&lcd_buf),lcdp(p),lcd_buf(p) {}
    /// access LCD object  
    LCDCLASS& lcd() {return *lcdp;}
    /// set cursor position.
    /// same as LCDCLASS::locate(), except return value type
    TextLCD_ostream& locate(int column, int row) {
        lcdp->locate(column,row);
        return *this;
    }
    /// clear screen
    /// same as LCDCLASS::cls(), except return value type
    TextLCD_ostream& cls(){
        lcdp->cls();
        return *this;
    }
private:
    LCDCLASS* const lcdp;
    class TextLCD_streambuf : public std::streambuf {
    public:
        TextLCD_streambuf(LCDCLASS *p) : lcdp(p) {}
        virtual int_type overflow( int_type c = EOF ) {
            if( c != EOF ) lcdp->putc(c);
            return c;
        }

    private:
        LCDCLASS *lcdp;
    } lcd_buf;
};

#ifndef NOTextLCD_h
//for compatibility to previous version
#include "TextLCD.h"
// specialized version
typedef TextLCD_ostream<TextLCD_Base> lcd_ostream;
#endif

#endif