/*
 * TC77 SPI Thermal Sensor
 *
 *  mbed                 TC77
 *  MOSI ---R 10K---+
 *                  |
 *  MISO -----------+--- pin1 SI/O.
 *  SCK  --------------- pin2 SCK.
 *  CS   --------------- pin7 CS(active low).
 *
 */

#ifndef TC77_H
#define TC77_H

#include "mbed.h"

/** TC77 SPI Thermal Sensor chip
 *
 * @note pin connection
 * @code
 * mbed                 TC77device
 * MOSI ---R 10K---+
 *                 |
 * MISO -----------+--- pin1 SI/O
 * SCK  --------------- pin2 SCK
 * CS   --------------- pin7 CS(active low)
 * @endcode
 *
@note sample program
@code
#include "mbed.h"
#include "TC77.h"

SPI spi1(p5,p6,p7);
TC77 tc77(&spi1, p8);

int main() {
    while(true) {
        printf("%.1f \r\n",tc77.temperature());
        wait(1.0);
    }
}
@endcode
*/
class TC77
{
    SPI *spi;
    DigitalOut cs;
public:
    //! @param s pointer to SPI object
    //! @param pin PinName of CS
    TC77(SPI *s, PinName pin);

    //! go to shutdown mode(power save)
    inline void shutdown(void) {write(0xffff);}
    //! start from shutdown mode
    void start(void);
    //! get device ID
    uint16_t id(void);
    //! get temperature @return Temperature value, expressed in degrees Celsius
    float temperature(void);
protected:
    //! read data and send command.
    //! It is impossible in the TC77 to perform the writing and reading at the same time.
    //! After reading 16bit, TC77 is ready to write. So total transferred bit is 32. 
    int16_t write(int16_t command);
    //! read data.
    //! transferred 16bit only
    int16_t read(void);
};

#endif