#include "TC77.h"

TC77::TC77(SPI *s, PinName pin):spi(s),cs(pin)
{
    cs=1;
    spi->format(16);
    spi->frequency(100*1000);
    start();
}

void TC77::start(void)
{
    write(0x0000);
    //shutdownモードからの復帰には最大400ms掛かる（データシートより）
    wait_ms(400);
}

uint16_t TC77::id(void)
{
    shutdown();
    int16_t v=write(0x0000);
    wait_ms(400);
    return v;
}

float TC77::temperature(void)
{
    int16_t t0=read();
    //bit2が0のときは測定が終わっていないので値は不正
    while((t0&0x0004)==0) {
        wait_ms(400);
        t0=read();
    }
    return ((signed int)t0>>3)*0.0625f;
}

//TC77は読み取りと書込みが同時には出来ない
//16bit読み込むと次の16bitが書込みになる
int16_t TC77::write(int16_t command)
{
    cs=0;
    int16_t v=spi->write(0x0000);
    spi->write(command);
    cs=1;
    return v;
}

//読むだけならば16bitのやり取りで良い
int16_t TC77::read(void)
{
    cs=0;
    int16_t v=spi->write(0x0000);
    cs=1;
    return v;
}
