/* Sample for MAPLE-mini TypeA board(marutsu-elec MARM02-BASE)
 * マルツの MAPLE-mini TypeA基板(型番MARM02-BASE)用の動作確認用のプログラムです。
 * mbed1768での動作を確認しています。
 */
 
#include "mbed.h"
//液晶モジュール MI2CLCD-01 I2C(p28,p27)
#include "TextLCD.h"
//RTC RX-8025SA I2C(p28,p27) INTA-p25 INTB-p26
#include "RX8025.h"
//地磁気+加速度センサモジュール MLSM303DLHC I2C(p28,p27)
#include "LSM303DLHC.h"
//microSD card slot SPI(P5,p6,p7,CS-p22 CD1-p29)
#include "SDFileSystem.h"
//基板に作り込みの静電式タッチパッド p15~18
#include "TouchSense.h"
//圧電スピーカ p20
//TypeB,C基板接続用コネクタ UART(p9,p10) I2C(p28,p27)

DigitalOut myled(LED1);

I2C i2c(p28,p27); // SDA, SCL
TextLCD_I2C_N lcd(&i2c, ST7032_SA, TextLCD::LCD16x2, NC, TextLCD::ST7032_3V3);
// LCD icon test patterns
const int MAXICONS=13;
struct {
    int8_t address;
    int8_t data;
} const icons[MAXICONS] = { {0x00,0x10},{0x02,0x10},{0x04,0x10},{0x06, 0x10},
                {0x07,0x10},{0x07,0x08},{0x09,0x10},{0x0b,0x10},
                {0x0d,0x1e},{0x0d,0x1a},{0x0d,0x12},{0x0d,0x02},
                {0x0f,0x10} }; 

RX8025 rtc(i2c);
LSM303DLHC compass(&i2c);

/* SD filesystem with card detection
 */
class SDFileSystemCD : public SDFileSystem {
    DigitalIn card_detect;
public:
    SDFileSystemCD(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName cd, const char* name)
        : SDFileSystem(p5, p6, p7, p22, "sd"), card_detect(cd, PullUp) {
    }
    bool cardExist(void) { return card_detect==0; }
};
SDFileSystemCD sd(p5, p6, p7, p22, p29, "sd");

//基板の裏側に触らないと ONにならない
//構造的にそういう仕様っぽいけど、どうなんだろ？
TouchSense sw1(p15),sw2(p16),sw3(p17),sw4(p18);

//圧電スピーカかp20に繋がっている
//このボードのメインターゲットの MyARM基板では p20をPWMに出来るらしいけど
//mbed1768では PWMに出来ないので DigitalOutで使用
class MmASpeaker : public DigitalOut {
public:
    MmASpeaker(PinName p) : DigitalOut(p) {}
    void beep(int32_t hz=1000, int32_t ms=100) {
        for(int i=0; i<hz*ms/1000; i++) {
            write(1);
            wait_us(1000*1000/hz/2);
            write(0);
            wait_us(1000*1000/hz/2);
        }
    }
};
MmASpeaker speaker(p20);

int main() {
    lcd.setContrast(32);
    lcd.cls();
    lcd.printf("Hello World!");
    lcd.locate(0,1);
    if(sd.cardExist()) {
        lcd.printf("SDcard Exist");
        mkdir("/sd/mydir", 0777);
        FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
        if(fp == NULL) {
            error("Could not open file for write\n");
        }
        fprintf(fp, "Hello fun SD Card World!");
        fclose(fp);
    } else lcd.printf("No SDcard");
    Times t={0,0,0,0,0,0,0};
    rtc.setTIME(t);
    sw1.calibration();
    sw2.calibration();
    sw3.calibration();
    sw4.calibration();
    wait(3.0);
    speaker.beep();
    
    int iconcounter=0;
    while(1) {
        Times t=rtc.getTIME();
        compass.getAccel();
        compass.getMagnet();
        int sw=(((sw1.sense()<<1 | sw2.sense())<<1) | sw3.sense())<<1 |sw4.sense();
        speaker.beep(1600/sw);
        
        lcd.locate(0,0);
        lcd.printf("%1x  %.1f %d       ", sw, compass.temperature(), compass.accelX());
        lcd.locate(0,1);
        lcd.printf("%02X:%02X:%02X %.1f", t.hours, t.minutes, t.seconds, compass.orientation());
        lcd.clrIcon();
        lcd.setIcon(icons[iconcounter].address,icons[iconcounter].data); 
        if(++iconcounter >= MAXICONS) iconcounter=0; 
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
