#ifndef RADIO_H
#define RADIO_H

#include "mbed.h"
#include "rtos.h"

// THREAD SUPPORT SIGNALS
#define START_THREAD 0x01
#define NEW_DATA 0x02
#define SET_LED_TICK 0x04

typedef struct RTP_t {
    uint8_t *payload;
    uint8_t port;
    bool    ack;
    uint8_t destination;
    uint8_t source;
    uint8_t size;
} RTP_t;


class Radio
{
public:
    Radio();
    Radio(PinName, PinName);
    virtual ~Radio() {};

    bool send(const RTP_t&);

    virtual void address(uint8_t address) {};
    uint8_t address(void) const {
        return _addr;
    }

    virtual void freq(uint32_t) {};
    uint32_t freq(void) const {
        return _freq;
    }

    virtual void channel(uint8_t) {};
    uint8_t channel(void) const {
        return _channel;
    }

    virtual void powerUp(void) = 0;
    
    bool hasError(void);

protected:
    virtual void put_pck(uint8_t*, uint8_t) = 0;
    virtual bool get_pck(uint8_t*, uint8_t*) = 0;

    static const int BUFFER_SIZE = 70;
    uint8_t     buffer[BUFFER_SIZE];

    bool        _need_ack;
    uint8_t     _channel;
    uint32_t    _freq;
    uint8_t     _addr;
    int8_t      _rssi;

    uint8_t _p_count;

    static void transmit_thread(void const*);
    static void receive_thread(void const*);
    SPI *_spi;

    Thread _receive_thread;
    Thread _transmit_thread;
    Thread _tx_led_thread;
    Thread _rx_led_thread;

    InterruptIn *_rx_int;
    
        DigitalOut _err_led;

    bool _has_error;

private:
    void isr_receive(void);

    DigitalOut _tx_led;
    DigitalOut _rx_led;
    static void led_tick(void const*);
};

#endif  // RADIO_H