#include "CC1101.h"

#define CC_NUMBER_OF_SUB_BANDS 1

uint16_t CC1101::scan(void)
{
    int8_t i;
    int16_t channel;

    uint8_t rssi_offset = 74;
    carrierSenseCounter = 0;

    uint8_t lastChannel = 10;
    uint16_t limitTest0Reg = 0;
    int16_t highRSSI = -150;
    uint16_t selectedChannel = 25;


// Freq. Band Range Channel
// 0 779.009766 - 829.997314 0 - 255 All 0x0B
// 1 830.196869 - 881.184418 0 - 255 <- 154 = 0x0B, 155 -> = 0x09
// 2 881.384369 - 927.972992 0 - 233 All 0x09
    /*
        uint8_t freqSettings[CC_NUMBER_OF_SUB_BANDS][3] = {{0x1D, 0xF6, 0x40},
            {0x1F, 0xEE, 0x3F},
            {0x21, 0xE6, 0x3F}
        };
    */


// 1.1) Set the base freq. for the current sub band. The values for FREQ2, FREQ1, and FREQ0 can be found in
// freqSettings[subBand][n], where n = 0, 1, or 2
    /*
    for (int n=0; n<3; n++) {
        write_reg(CCxxx0_FREQ2 + n, freqSettings[subBand][n]);
    }
    */

    uint8_t calCounter = 0;

    // 1.4.2.1) Set TEST0 register = 0x09
    write_reg(CCxxx0_TEST0, 0x09);

    // 1.4.2.2) Set FSCAL2 register = 0x2A
    write_reg(CCxxx0_FSCAL2, 0x2A);


    // 1.3) Loop through all channels
    for (channel = 0; channel <= lastChannel; channel++ ) {
        int8_t pktStatus;

        // 1.3.1) Set CHANNR register = channel
        write_reg(CCxxx0_CHANNR, channel);

        // 1.4.3) Calibrate for every 4th ch. + at start of every sub band and every time the TEST0 reg. is changed
        if (calCounter++ == 0) {
            // 1.4.3.1) Perform a manual calibration by issuing an SCAL strobe command
            calibrate();
        }


        // 1.4.4)) Reset Calibration Counter (if calCounter = 5, we are 1 MHz away from the frequency where a
        // calibration was performed)
        if (calCounter == 4) {
            // 1.4.4.1) Calibration is performed if calCounter = 0
            calCounter = 0;
        }


        // 1.3.3) Enter RX mode by issuing an SRX strobe command
        rx_mode();

        // 1.3.4) Wait for radio to enter RX state (can be done by polling the MARCSTATE register)
        while(mode() != 0x0D);

        // 1.3.5) Wait for RSSI to be valid (See DN505 [7] on how long to wait)
        wait(0.4);

        // 1.3.6) Read the PKTSTATUS register while the radio is in RX state (store it in pktStatus)
        pktStatus = status(CCxxx0_PKTSTATUS);

        // 1.3.7) Enter IDLE state by issuing an SIDLE strobe command
        strobe(CCxxx0_SIDLE);

        // 1.3.8) Check if CS is asserted (use the value obtained in 1.3.6)
        if (pktStatus & 0x40) { // CS is asserted

            // 1.3.8.1) Read RSSI value and store it in rssi_dec
            rssi_dec = status(CCxxx0_RSSI);

            // 1.3.8.2) Calculate RSSI in dBm (rssi_dBm)(offset value found in rssi_offset)
            if (rssi_dec & 0x80) {
                rssi_dBm = (rssi_dec - 256)>>1;  // negate and divide by 2
            } else {
                rssi_dBm = rssi_dec>>1; // divide by 2
            }
            rssi_dBm -= rssi_offset;  // offset adjustment


            std::printf("RSSI: %d\r\n", rssi_dBm);
            // 1.3.8.3) Store the RSSI value and the corresponding channel number
            rssiTable[carrierSenseCounter] = rssi_dBm;
            channelNumber[carrierSenseCounter] = channel;
            carrierSenseCounter++;
        }
    } // End Channel Loop


    // 1.4) Before moving on to the next sub band, scan through the rssiTable to find the highest RSSI value. Store
    // the RSSI value in highRSSI and the corresponding channel number in selectedChannel
    for (i = 0; i < carrierSenseCounter; i++) {
        if (rssiTable[i] > highRSSI) {
            highRSSI = rssiTable[i];
            selectedChannel = channelNumber[i];
        }
    }


    // 1.5) Reset carrierSenseCounter
    //  carrierSenseCounter = 0;

// } // End Band Loop

    /*

    // 2) When all sub bands have been scanned, find which sub band has the highest RSSI (Scan the highRSSI[subBand]
    // table). Store the subBand (0, 1, or 2) and the corresponding channel in the global variables activeBand and
    // activeChannel respectively
    int16_t tempRssi = -150;
    // for (int subBand = 0; subBand < CC_NUMBER_OF_SUB_BANDS; subBand++)
    // {
        if (highRSSI >= tempRssi) {
            tempRssi = highRSSI;
            activeChannel = selectedChannel;
            activeBand = subBand;
        }
    // }

    */

    activeChannel = selectedChannel;

    std::printf("Active Channel: %u\r\nRSSI: %ddBm\r\n", activeChannel, highRSSI);

    return activeChannel;

}