/*
 * mbed library for RingBuffer
 * Copyright (c) 2010 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

#ifndef RINGBUFFER_H
#define RINGBUFFER_H

#include "mbed.h"

class RingBuffer : public Stream  {
public:
RingBuffer();
RingBuffer (unsigned int p_size = 0);

/*
#if DOXYGEN_ONLY
    int putc(int c);
    int printf(const char* format, ...);
#endif
*/
    int     put(char*, int);
    char    get(void);
    int     get(char*, int);
    void    clear(void);
    int     available(void);
    int     use(void);

private:
    // Stream implementation functions
    virtual int _putc(int value);
    virtual int _getc();

    volatile unsigned char   *buf;
    unsigned int    size;
    unsigned int    addr_w;
    unsigned int    addr_r;
    void init(unsigned int);
};

#endif // RINGBUFFER_H
