#include "Radio.h"

Radio::Radio() :
    _tx_led(NC),
    _rx_led(NC),
    _err_led(NC),
    _receive_thread(&Radio::receive_thread, this, osPriorityLow, 0),
    _transmit_thread(&Radio::transmit_thread, this, osPriorityLow, 0),
    _tx_led_thread(&Radio::led_tick, &_tx_led, osPriorityLow, 0),
    _rx_led_thread(&Radio::led_tick, &_rx_led, osPriorityLow, 0)
{
    _channel = 1;
    _addr = 0;
    _freq = 0;
    _need_ack = false;
    _p_count = 0;
    _has_error = false;
}

Radio::Radio(PinName tx_led, PinName rx_led) :
    _tx_led(tx_led),
    _rx_led(rx_led),
    _err_led(p29),
    _receive_thread(&Radio::receive_thread, this, osPriorityRealtime, 2048),
    _transmit_thread(&Radio::transmit_thread, this, osPriorityNormal, 1024),
    _tx_led_thread(&Radio::led_tick, &_tx_led, osPriorityLow, 128),
    _rx_led_thread(&Radio::led_tick, &_rx_led, osPriorityLow, 128)
{
    _channel = 1;
    _addr = 0;
    _freq = 0;
    _need_ack = false;
    _p_count = 0;
    _tx_led = 1;
    _rx_led = 1;
    
    // always off initially
    _err_led = 1;
    
    _has_error = false;
}

bool Radio::send(const RTP_t& packet)
{
    _need_ack = packet.ack;
    while (_need_ack) {
        this->put_pck(packet.payload, packet.size);
    }

}

// INTERRUPT ROUTINES
void Radio::isr_receive(void)
{
    _receive_thread.signal_set(NEW_DATA);
}

void Radio::led_tick(void const *arg)
{
    DigitalOut *led = (DigitalOut*)arg;
    
    // initial LED state to OFF
    *led = 1;

    while(1) {
        // wait for signal to be set before doing anything
        osSignalWait(SET_LED_TICK, osWaitForever);

        // blink the led once
        *led = !*led;
        Thread::wait(10);   // ms
        *led = !*led;
        Thread::wait(60);
    }
}

bool Radio::hasError(void){
    return _has_error;
    }