#include "mbed.h"
#include "SX1509.h"
 
#define WAIT_TIME 0.1
 
DigitalOut led1(LED1);
SX1509  expander(p9, p10); // sda, scl
 
int main()
{
    // Setup the I/O pins for open drain outputs to allow controlling grid of LEDs
    expander.setOpenDrain(A,ON);
    
    // Main loop
    while (1) {
        
        // Set the "A" rows to high, then shift the open drain outputs so they open for each row of LEDs
        for (int i=0; i<8 ; i++) {
            expander.setA(0xFF<<i+1);
            expander.set(i+8);
            wait(WAIT_TIME);
        }
 
        // Toggle the on-board led to indicate activity
        led1=!led1;
 
        // Now shift the rows off the led grid array
        for (int i=0; i<8 ; i++) {
            expander.setB(0xFF>>i+1);
            expander.clear(i);
            wait(WAIT_TIME);
        }
    }
}