#ifndef LOGGER_H
#define LOGGER_H

#include "mbed.h"
#include <string>

#ifdef RJ_DEBUG_LEVEL
#undef RJ_DEBUG_LEVEL
#endif

#define RJ_DEBUG_LEVEL 1

#if RJ_DEBUG_LEVEL > 0

#define LOG(x, ...) std::printf("[LOG: %s: %u]\r\n"x"\r\n", __FILE__, __LINE__, ##__VA_ARGS__);
#define EVENT(x, ...) std::printf("[EVENT: %s: %u]\r\n"x"\r\n", __FILE__, __LINE__, ##__VA_ARGS__);
#define WARNING(x, ...) std::printf("[WARNING: %s: %u]\r\n"x"\r\n", __FILE__, __LINE__, ##__VA_ARGS__);

#else

#define LOG(x,...)
#define EVENT(x,...)
#define WARNING(x,...)

#endif

/*
void LOG(const std::string& statement)
{
    FILE *fp = fopen("/local/log.txt", "w");  // Open text file for tracking boot sequence results
    
    std::printf("%c line #%u:\r\n%s\r\n", __FILE__, __LINE__, statement);
    fprintf(fp ,"%c", statement.c_str());

    if (fp == NULL) {
        error("Could not get pointer to log file\r\n");
    }
    
    fclose(fp); // close the file pointer
}
*/
#endif  // LOGGER_H