#include "robot.h"

// Create a file system if needed for writing startup information to the boot log
#if RJ_BOOT_LOG
LocalFileSystem local("local");     // Create the local filesystem object
#endif
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Serial pc(USBTX, USBRX);

// Sets the mbed's baudrate for debugging purposes
void baud(int baudrate)
{
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}

// Main program operations =======================
int main()
{
    led4 = 0;
// Set the baud rate
    baud(57600);

// Check the mbed's firmware if enabled
#if RJ_CHECK_FIRMWARE
    std::string firmware;
    firmware_version(firmware);  // this is from FirmwareHelper.h
    LOG("Firmware Version: %s\r\n", firmware.c_str());

// Write any errors to a log file if enabled
#if RJ_BOOT_LOG
    LOG("Begin logging\r\n");
#endif

#endif

    DigitalOut temppp(RJ_PRIMARY_RADIO_INT, 1);

// Create a new physical hardware communication link
    CC1101 radio_900(
        RJ_SPI_BUS,
        RJ_PRIMARY_RADIO_CS,
        RJ_PRIMARY_RADIO_INT
    );

// Create a Communication Module Object
    CommModule comm;

    radio_900.setModule(comm);

    comm.TxHandler((CommLink*)&radio_900, &CommLink::sendPacket, 8);
    comm.openSocket(8);

// Open a socket for the Communication Module. Give it a port number and a function to call when a packet of that port number is received
    led3 = 1;

// Create a dummy packet that is set to send out from socket connection 8
    RTP_t dummy_packet;
    for (int i=0; i<20; i++)
        dummy_packet.data[i] = i;

    dummy_packet.data_size = 20;
    dummy_packet.port = 8;
    dummy_packet.subclass = 1;


// Enable watchdog timer
//Watchdog watchdog;
//watchdog.set(RJ_WATCHDOG_TIMER_VALUE);

    led1 = 0;

    while(1) {
        led1 = !led1;
        //radio_900.status();
        //comm.send(dummy_packet);
        osDelay(500);

    }
}