/*
 * Example program showing how to get the temperature readings from
 * an MLX90614 infrared temperature sensor using an mbed.
 * http://www.haoyuelectronics.com/Attachment/GY-906/MLX90614.pdf
 *
 * Jonathan Jones
 */

#include "mbed.h"
#include "gy-906.h"

using namespace gy906;

I2C i2c(p9, p10);
const uint8_t addr = default_addr;

// kelvin to fahrenheit
float k2f(float raw_kelvin)
{
    return (raw_kelvin - 273.15) * 1.8 + 32;
}

// read and return one of the temperature regs
float get_temp(uint8_t reg) {
    char cmd[3] = { 0 };
    // read the temperature data (kelvin)
    cmd[0] = opcode::ram_access | reg;
    i2c.write(addr,cmd,1,true); i2c.read(addr,cmd,3);
    // convert to meaningful units, still in kelvin - just normalized
    return 0.02 * static_cast<float>((cmd[1]<<8)|cmd[0]);
}

int main() {
    uint8_t reg_addrs[] = { ram::T_ambient, ram::T_obj1 };
    float tt = 0.0;
    // clear terminal & hide cursor
    printf("\033[r\033[2J\033[?25l"); fflush(stdout);
    while (true) {
        for (size_t i = 0; i < sizeof(reg_addrs); ++i) {
            tt = get_temp(reg_addrs[i]);
            printf("\r\033[KT%u:\t%.2f°F\r\n", i, k2f(tt));
            fflush(stdout);
        }
        wait(0.1);
        printf("\033[%uA", sizeof(reg_addrs)); fflush(stdout);
    }
}