#ifndef BASE_STATION_H
#define BASE_STATION_H

#include "mbed.h"
#include "rtos.h"
#include "CC1101.h"

// 7-Segment pins
#define RJ_7_SEG_BIT_3_PIN  p17
#define RJ_7_SEG_BIT_2_PIN  p18
#define RJ_7_SEG_BIT_1_PIN  p19
#define RJ_7_SEG_BIT_0_PIN  p20
#define RJ_7_SEG_DOT_PIN    p15
#define RJ_7_SEG_LATCH_PIN  p16
#define RJ_7_SEG_PINS       RJ_7_SEG_BIT_3_PIN, RJ_7_SEG_BIT_2_PIN, RJ_7_SEG_BIT_1_PIN, RJ_7_SEG_BIT_0_PIN

// Primary Radio LEDs
#define RJ_PRIMARY_RADIO_LED_TX     p28
#define RJ_PRIMARY_RADIO_LED_RX     p30
#define RJ_PRIMARY_RADIO_LED_ERR    p29
#define RJ_PRIMARY_RADIO_LEDS       RJ_PRIMARY_RADIO_LED_TX, RJ_PRIMARY_RADIO_LED_RX, RJ_PRIMARY_RADIO_LED_ERR

// Secondary Radio LEDs
#define RJ_SECONDARY_RADIO_LED_TX     p24
#define RJ_SECONDARY_RADIO_LED_RX     p25
#define RJ_SECONDARY_RADIO_LED_ERR    p26
#define RJ_SECONDARY_RADIO_LEDS       RJ_SECONDARY_RADIO_LED_TX, RJ_SECONDARY_RADIO_LED_RX, RJ_SECONDARY_RADIO_LED_ERR

// Primary Radio Control Pins
#define RJ_PRIMARY_RADIO_CS_PIN     p11
#define RJ_PRIMARY_RADIO_INT_PIN    p12

// RGB Status LED
#define RJ_RGB_LED_RED_PIN      p23
#define RJ_RGB_LED_GREEN_PIN    p21
#define RJ_RGB_LED_BLUE_PIN     p22
#define RJ_RGB_LED_ANNODE       p27
#define RJ_RGB_LED_PINS         RJ_RGB_LED_RED_PIN, RJ_RGB_LED_GREEN_PIN, RJ_RGB_LED_BLUE_PIN

// SPI Bus lines
#define RJ_SPI_MOSI_PIN     p5
#define RJ_SPI_MISO_PIN     p6
#define RJ_SPI_SCK_PIN      p7
#define RJ_SPI_PINS         RJ_SPI_MOSI_PIN, RJ_SPI_MISO_PIN, RJ_SPI_SCK_PIN

#define R   0
#define G   1
#define B   2

#endif  //  BASE_STATION_H
