// potenciometro controla la matriz 
// y buzzer al mismo tiempo envia por 
// el puerto serie

#include "mbed.h"
#include "neopixel.h"
#include "USBSerial.h"

// Matrix led output pin
#define MATRIX_PIN P0_9
#define NLEDS 25

AnalogIn   ain(P0_22);

unsigned int counter = 0;   
USBSerial serial;

neopixel::Pixel buffer[NLEDS];
PwmOut speaker(P0_8);

void setPixel(uint32_t posicion, uint8_t red, uint8_t green, uint8_t blue) {
  buffer[posicion].red=red;
  buffer[posicion].green=green;
  buffer[posicion].blue=blue;
}

int main()
{
    // Turn off miniblip buzzer
    speaker=0.0;

    serial.printf("Hello world!\n");    
    while(true) {   
        float pot = ain.read() * 50.0f;
        serial.printf("mini blip is alive for %i seconds.\n", counter);
        serial.printf("Pot: %3.3f%%\n", pot);
        counter++;  
    
        int rgb = 20* floor( pot/50 ); 
        neopixel::PixelArray array(MATRIX_PIN);
        for(int i=0;i<NLEDS;i++) {
            setPixel(i, rgb, 20-rgb, 20-rgb);
        }
                
        array.update(buffer, NLEDS); 

    }
    
}// miniblip led matrix demo
