
#include "SI_LIS.h"

I2C i2c(p9, p10);  //  (SDA,SCL)
int bias1,bias2,bias3,PS1,PS2,PS3,VIS;
unsigned char LowB,HighB;
unsigned int IR;
extern char rx_data[4];
extern char accel_2_data[2];
extern char accel_data[6];

void restart()
{
    wait_ms(30);
    i2c.frequency(400000);
    command(RESET);
    wait_ms(30);

    write_reg(HW_KEY,HW_KEY_VAL0);
    write_reg(PS_LED21,0x41);   // values when Si1142 and LED's put into hat
    write_reg(PS_LED3,0x00);

    //  CHLIST Parameter
    write_reg(PARAM_WR, PS1_TASK + PS2_TASK);   //use PS1, PS2 to fire LED's
    command(PARAM_SET + (CHLIST & 0x1F));

    //  PS Gain:  by factor of (2 ^ PS_ADC_GAIN). Max gain: 128 (0x7).
    write_reg(PARAM_WR, 0x03);
    command(PARAM_SET + (PS_ADC_GAIN & 0x1F));

    //  PS_ADC_COUNTER  (Recommend one’s complement of PS_ADC_GAIN.)
    write_reg(PARAM_WR, 0x40);
    command(PARAM_SET + (PS_ADC_COUNTER & 0x1F));

    //  ADC_OFFSET (adds to reported so there's no confusion with 0xFFFF overrange indicator) reset: 0x80
    write_reg(PARAM_WR, 0x00);
    command(PARAM_SET + (ADC_OFFSET & 0x1F));
    
    //  PS_Encoding  (Bit 5: When set,  ADC reports least significant 16 bits of 17-bit ADC
    //  Current Concept: don't set, but gain it up by another 2x

    write_reg(INT_CFG,1);  //set bit 0 to 1.  Requires clearing interrupt pin 

    // IRQ_ENABLE 0x04:   Bit 3:  PS2_IE     Bit 2: PS1_IE
    write_reg(IRQ_ENABLE,0x04);

    //IRQ_MODE1:  00: PS1_INT is set whenever a PS1 measurement has completed.
    write_reg(IRQ_MODE1,0);
    write_reg(IRQ_MODE2,0);
    
    wait_ms(30);

    write_reg(MEAS_RATE,0x20);  //0x84 should be every 10 ms.  Need calcs if less than that
    wait_ms(30);
    write_reg(PS_RATE,0x08);  //this should be a multiplier of 1
    wait_ms(30);
}

void command_test()
{
    write_reg(COMMAND,NOP);
}

void command(char cmd)
{
    int val;

    val = read_reg(RESPONSE,1);
    while(val!=0) {
        write_reg(COMMAND,NOP);
        val = read_reg(RESPONSE,1);
    }
    do {
        write_reg(COMMAND,cmd);
        if(cmd==RESET) break;
        val = read_reg(RESPONSE,1);
    } while(val==0);
}

int command2(char cmd)
{
    int val;
    int i = 0;
    do {
        write_reg(COMMAND,cmd);
        val = read_reg(RESPONSE,1);
        i = i+1;
    } while(val==0);
    return val;
}

void command3(char cmd)
{
    write_reg(COMMAND,cmd);
}

char read_reg2 (/*unsigned*/ char address) // Read a register
{
    char tx[1];
    tx[0] = address;
    i2c.write((IR_ADDRESS << 1) & 0xFE, tx, 1);

    i2c.read((IR_ADDRESS << 1) | 0x01, rx_data, 4);
    return 0;
}

char read_reg (/*unsigned*/ char address, int num_data) // Read a register
{
    char tx[1];
    char rx[1];
    tx[0] = address;
    i2c.write((IR_ADDRESS << 1) & 0xFE, tx, num_data);

    i2c.read((IR_ADDRESS << 1) | 0x01, rx, num_data);
    return rx[0];
}

void write_reg(char address, char num_data) // Write a resigter
{
    char tx[2];
    tx[0] = address;
    tx[1] = num_data;
    i2c.write((IR_ADDRESS << 1) & 0xFE, tx, 2);
}

void Init_Accel ()
{
    char        data[2];
    char        Reg_Num;
    char        Reg_Val;
    
    Reg_Num = 0x20; // CTRL_REG1
    // Nib 1 of 0101: Normal mode, 100 Hz;  Nib 2 of 0111: Normal mode, XYZ enabled
//    Reg_Val = 0x57; // Nib 1 of 0101: Normal mode, 100 Hz;  Nib 2 of 0111: Normal mode, XYZ enabled
    // Nib 1 of 0111: 400 Hz;  Nib 2 of 0111: XYZ enabled
    Reg_Val = 0x97;  //0x77 is 400 hz    --    0x97 is 1.2 khz

    data[0]   = Reg_Num;     //register to be written to
    data[1]   = Reg_Val;     //data
    i2c.write((LIS_Addr << 1) & 0xFE, data, 2);

    wait(0.050);    // Delay needed, or 2nd write doesn't work

    Reg_Num = 0x21; // CTRL_REG2
//    Reg_Val = 0xA0; 
    Reg_Val = 0xA8;    //  1010_1000
    // 7-6 10: Normal filter mode;  5-4 10: Cut off freq; 3-0 0000: bypass interrupts
    // High-pass filter bits 5-4: @ 100 Hz:  00 - 2Hz   01 - 1Hz   10- 0.5Hz   11- 0.2Hz
    data[0]   = Reg_Num;     //register to be written to
    data[1]   = Reg_Val;     //data
    i2c.write((LIS_Addr << 1) & 0xFE, data, 2);

    wait(0.050);    // Delay needed?
}

void Get_Accel_Register (char Reg_Num)
{
    char        data;
    char        reg;

    reg = Reg_Num;

    i2c.write((LIS_Addr << 1) & 0xFE , &reg, 1 );  // Write register number
    i2c.read ((LIS_Addr << 1) | 0x01, &data, 1 );  // Receive Byte from Slave
    accel_data[0] = data;
}

void Get_Accel_Reg_6 (char Reg_Num) // Read 6 registers
{
    char  reg;
    reg = Reg_Num | 0x80; // set bit 7 high to enable burst read
    i2c.write((LIS_Addr << 1) & 0xFE, &reg, 1);
    i2c.read((LIS_Addr << 1) | 0x01, accel_data, 6);
}


