#include "Navigator.h"
#include "SMARTGPU.h"
 //
 #include <stdio.h>
#include <iostream>

Navigator::Navigator(Menu *root, RPG &rpg, SMARTGPU *lcd) : activeMenu(root), rpg(rpg), lcd(lcd) 
{
    bottom = root->selections.size();
    cursorPos = 0;
    cursorLine = 1;
    button = 0;
    lastButton = 0;
    
    printMenu();
    printCursor();
}

void Navigator::printMenu()
{ 
   lcd->erase();

    if(bottom == 1){ // the current Menu only has one selection
        //lcd->printf("%s\n", activeMenu->selections[0].selText);
        //activeMenu->selections[0].selText;
        lcd->string(70,10,300,220,YELLOW,FONT4,TRANS,activeMenu->selections[0].selText);  //write a string on the screen
    } else {
       // if(cursorLine == 4){ // if we're at the bottom
           // lcd->printf("%s\n", activeMenu->selections[cursorPos-1].selText);
          lcd->string(5,5,300,220,WHITE,FONT6,TRANS,activeMenu->selections[4].selText);  //write a string on the screen
            lcd->string(30,40,300,220,WHITE,FONT6,TRANS,(activeMenu->selections[0].selText));  //write a string on the screen
             lcd->string(30,80,300,220,WHITE,FONT6,TRANS,activeMenu->selections[1].selText);  //write a string on the screen
            lcd->string(30,120,300,220,WHITE,FONT6,TRANS,(activeMenu->selections[2].selText));  //write a string on the screen
            lcd->string(30,160,300,220,WHITE,FONT6,TRANS,activeMenu->selections[3].selText);  //write a string on the screen
            
      //  } else {
           
           // lcd->string(30,30,300,220,WHITE,FONT6,TRANS,activeMenu->selections[0].selText);  //write a string on the screen
           //  lcd->string(30,70,300,220,WHITE,FONT6,TRANS,activeMenu->selections[1].selText);  //write a string on the screen
           //  lcd->string(30,110,300,220,WHITE,FONT6,TRANS,(activeMenu->selections[2].selText));  //write a string on the screen
            // lcd->string(30,150,300,220,WHITE,FONT6,TRANS,activeMenu->selections[3].selText);  //write a string on the screen
        //}
    }
}

void Navigator::printCursor()
{   

    
    if(activeMenu->selections[cursorPos].childMenu == NULL) 
        // printf("No child menu\n");
        lcd->string(10,200,300,220,WHITE,FONT2,TRANS,"_      ");  //write a string on the screen
        
    else 
        lcd->string(10,200,300,220,WHITE,FONT2,TRANS, activeMenu->selections[cursorPos].childMenu->menuID);  //write a string on the screen
     
        //printf("child menu: %s\n", activeMenu->selections[cursorPos].childMenu->menuID);
     
 //   lcd->locate(0,0); cursorPos  cursorLine
    if(cursorPos == 0){
        lcd->string(15,40,300,220,WHITE,FONT6,TRANS,">"); 
        lcd->string(15,80,300,220,WHITE,FONT6,TRANS," "); 
        lcd->string(15,120,300,220,WHITE,FONT6,TRANS," "); 
        lcd->string(15,160,300,220,WHITE,FONT6,TRANS," "); 
    } else if(cursorPos == 1){
        lcd->string(15,40,300,220,WHITE,FONT6,TRANS," "); 
        lcd->string(15,80,300,220,WHITE,FONT6,TRANS,">"); 
        lcd->string(15,120,300,220,WHITE,FONT6,TRANS," "); 
        lcd->string(15,160,300,220,WHITE,FONT6,TRANS," "); 
    } else if(cursorPos == 2){
        lcd->string(15,40,300,220,WHITE,FONT6,TRANS," "); 
        lcd->string(15,80,300,220,WHITE,FONT6,TRANS," "); 
        lcd->string(15,120,300,220,WHITE,FONT6,TRANS,">"); 
        lcd->string(15,160,300,220,WHITE,FONT6,TRANS," "); 
    } else if(cursorPos == 3){
        lcd->string(15,40,300,220,WHITE,FONT6,TRANS," "); 
        lcd->string(15,80,300,220,WHITE,FONT6,TRANS," "); 
        lcd->string(15,120,300,220,WHITE,FONT6,TRANS," "); 
        lcd->string(15,160,300,220,WHITE,FONT6,TRANS,">"); 
    }
}

void Navigator::poll()
{
 
    if((direction = rpg.dir())!=0){ //Get Dir
        wait(0.2); 
        if(direction == 1) moveDown();
        else if(direction == -1) moveUp();
    }
       
      if ((button = rpg.pb()) && !lastButton){ //prevents multiple selections when button is held down
        wait(0.2);
        if(activeMenu->selections[cursorPos].fun != NULL){
            (activeMenu->selections[cursorPos].fun)();
        }
        if(activeMenu->selections[cursorPos].childMenu != NULL){
            activeMenu = activeMenu->selections[cursorPos].childMenu;
            bottom = activeMenu->selections.size();
            cursorPos = 0;
            cursorLine = 1;
            printMenu();
            printCursor();
        }
    }
    lastButton = button;
}

void Navigator::moveUp()
{
    if(cursorLine == 1){
        printMenu();
    } else if(cursorLine == 5){
        cursorLine = 1;
    }
    
    if(cursorPos != 0){
        cursorPos--;
        printMenu();
    }
    printCursor();
}

void Navigator::moveDown()
{
    if(cursorLine == 1){
        cursorLine = 5;
    } else if(cursorLine == 5){
        printMenu();
    }
    
    if(cursorPos != (bottom-1)){
        cursorPos++;
        printMenu();
    }
    printCursor();
}