#include "mbed.h"
#include "moggo.h" //agrega la libreria que contiene las figuras.

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
//SPI deviceM(PB_5, PB_4, PB_3); //define el Clock, Dato salida (miso) y Dato de entrada (mosi).
//DigitalOut ssel (PB_9);         //Chip Select para el controlador.
Serial command(USBTX,USBRX); //habilitar la comunicacion serial a traves del puerto usb.

#define  VEL 250 //Velocidad de actualizacion de dato en el controlador.

uint8_t mat_act[11]={0,0,0,0,0,0,0,0,0,0,0};    //Matriz para mostrar en pantalla.
uint8_t mat_tmp[8]={0,0,0,0,0,0,0,0};    //Matriz temporal para arrojar las fichas.
uint8_t fila=0;
 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
}

void test()  //test
{
    sendSPI(0x09,0);        //no decodificacion
    sendSPI(0x0A,0x0);      //intensidad
    sendSPI(0x0B,0x07);     //usa 7 leds                     
    sendSPI(0x0C,1);        //no apaga
    sendSPI(0x0F,0);        //operacion normal     
}

void cop_mat(uint8_t a,uint8_t b,uint8_t c,uint8_t* fig,uint8_t columna)
{                    
        mat_tmp[0]= *(fig+a)>>columna-1; //Realiza una copia de la matriz actual fila por fila.
        mat_tmp[1]= *(fig+b)>>columna-1;
        mat_tmp[2]= *(fig+c)>>columna-1;       
}

void borrar() //borrar toda la matriz;
{
    int i;
    for(i=0;i<=8;i++)
    {
        sendSPI(0x0+i,0x00);
    }
};

void buscar_fil(){
    for (uint8_t i=0;i<8;i++){                      //Realiza la impresion de la matriz.
        if(mat_act[i]==0)
        fila=i;
        if(mat_act[i]!=0){
        fila=i-1;                                   //cambio de 2 a 1
        i=8;
        }
    }
    command.printf("\n buscar fila \n %d",fila);
    command.printf("\n ******************************* \n ");
};

void buscar_col(){
    uint8_t y;
        y= mat_act[fila] & mat_tmp[2];
        if(y != 0){
            fila=0;
            }
        else{
            fila++;
        }
        command.printf("\n fila cambiada en columna: y=%d",y);        
};

void guardar_mat(){
        //borrar();
        wait_ms(VEL);
        mat_act[fila-2]=mat_tmp[0];
        mat_act[fila-1]=mat_tmp[1];     //pasa de 0 a -1
        mat_act[fila]=mat_tmp[2];       //pasa de +1 a 0
    };


void imp_mat(uint8_t *temp){
    uint8_t i=0;
    buscar_fil();
    for (i=0;i<=fila;i++){                      
    
        sendSPI(i-1,0);
        sendSPI(i-1,*(temp+0));
        sendSPI(i,*(temp+1));
        sendSPI(i+1,*(temp+2));                     //pasa de i+2 a i+1
        wait_ms(VEL);
    }
}

void dibujar(char type_fig,char grados,char columna)
{
    //borrar();    
    switch (type_fig){                  //Se envia el vector que contiene la figura a la funcion copiar matriz.
        case 1: cop_mat(5,1,1,FIG_ALL,columna); break;  //1: cuadro;
        
        case 2: if(grados==1 || grados==3)              
                cop_mat(0,0,0,FIG_ALL,columna);
                if(grados==2 || grados==4)
                cop_mat(5,5,2,FIG_ALL,columna);         //2: I;    
                break;
                  
        case 3: if(grados==1)
                cop_mat(0,0,1,FIG_ALL,columna);         //3: L; 
                if(grados==2)
                cop_mat(5,2,0,FIG_ALL,columna);
                if(grados==3)
                cop_mat(1,0,0,FIG_ALL,columna);
                if(grados==4)
                cop_mat(5,0,2,FIG_ALL,columna);
                break;  //2: I;
        
        case 4: if(grados==1)
                cop_mat(5,2,0,FIG_ALL,columna);         //4: T;
                if(grados==2)
                cop_mat(3,1,3,FIG_ALL,columna);
                if(grados==3)
                cop_mat(5,3,2,FIG_ALL,columna);
                if(grados==4)
                cop_mat(0,1,0,FIG_ALL,columna);
                break;
        
        case 5: if(grados==1 || grados==3)
                cop_mat(5,4,1,FIG_ALL,columna);   //5: S; 
                if(grados==2 || grados==4)
                cop_mat(0,1,3,FIG_ALL,columna);
                break; 
    }  
}

int main() {
    char tipo_fig=1,ncolumna=1,grados=1,lee1=0,lee2=0;  // enviar ficha y columna
    test();
    borrar();
    while(1){
        lee1=command.getc();                //recive '<' para iniciar la linea de comandos.
        tipo_fig=command.getc();
        grados=command.getc();
        ncolumna=command.getc();       
        lee2=command.getc();                //recive '>' para terminar la linea de comandos.
            if(lee1==0x3c && lee2==0x3e)    //solo imprime una figura si viene bajo el parametro '<(t_fig) (Grados) (Col)>'.
            {
            dibujar(tipo_fig,grados,ncolumna);
            imp_mat(mat_tmp);
            guardar_mat();
            }     
        }
    }