// Send a byte to a SPI slave, and record the response
#include "mbed.h"

// hardware ssel (where applicable)
//SPI device(PC_11, PC_12, PC_10,PA_15); // mosi, miso, sclk, ssel

// software ssel
//SPI device(PC_12, PC_11, PC_10); // mosi, miso, sclk
//DigitalOut cs(PA_15); // ssel
SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
InterruptIn button(USER_BUTTON);
DigitalOut led(LED1);
Serial command(USBTX,USBRX);
//Serial com_tar(PC_10,PC_11); //master f446R
Serial com_tar(PA_15,PB_7); //slave f411R

uint8_t a=0;

void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
}

double delay = 0.5; // 500 ms

void pressed()
{
    delay = 0.1; // 100 ms
    a=1;
    //sendSPI(a,3);
    command.printf("\n valor de a= %d",a);
    com_tar.putc(a);
}

void released()
{
    delay = 1; // 500 ms
    a=0;
    //sendSPI(a,3);
    command.printf("\n valor de a= %d",a);
    com_tar.putc(a);
}

int main()
{
    // Assign functions to button
    button.fall(&pressed);
    button.rise(&released);

    while (1) {
        int prender=com_tar.getc();
        if(prender==0){
        led = !led;
        wait(delay);  
        }
    }
}
