#include "mbed.h"
#include "moggo.h" //agrega la libreria que contiene las figuras.

SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
//SPI deviceM(PB_5, PB_4, PB_3); //define el Clock, Dato salida (miso) y Dato de entrada (mosi).
//DigitalOut ssel (PB_9);         //Chip Select para el controlador.
Serial command(USBTX,USBRX); //habilitar la comunicacion serial a traves del puerto usb.

#define  VEL 30 //Velocidad de actualizacion de dato en el controlador.

uint8_t mat_act[11]={0,0,0,0,0,0,0,0,0,0,0};    //Matriz para mostrar en pantalla.
uint8_t mat_tmp[8]={0,0,0,0,0,0,0,0};    //Matriz temporal para arrojar las fichas.
uint8_t mat_tmp1[8]={0,0,0,0,0,0,0,0};
uint8_t fila=1,cont=0,ncolumna=1,grados=1,ficha=0;
 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
}

void test()  //test
{
    sendSPI(0x09,0);        //no decodificacion
    sendSPI(0x0A,0x00);      //intensidad
    sendSPI(0x0B,0x07);     //usa 7 leds                     
    sendSPI(0x0C,1);        //no apaga
    sendSPI(0x0F,0);        //operacion normal     
}

void cop_mat(uint8_t a,uint8_t b,uint8_t c,uint8_t* fig,uint8_t columna)
{       
        mat_tmp[0]= *(fig+5)>>columna-1;             
        mat_tmp[1]= *(fig+a)>>columna-1; //Realiza una copia de la matriz actual fila por fila.
        mat_tmp[2]= *(fig+b)>>columna-1;
        mat_tmp[3]= *(fig+c)>>columna-1;       
}

void borrar() //borrar toda la matriz;
{
    int i;
    for(i=0;i<=8;i++)
    {
        sendSPI(i,0);
        mat_act[i]=0;    //Matriz para mostrar en pantalla.
    }
};

void buscar_fil(){
    for (uint8_t i=0;i<9;i++){                     
        if((mat_act[i]& mat_tmp[3])==0){
        fila=i;
        //command.printf("\n1- comparacion inicial:\n %d",mat_act[i]& mat_tmp[2]);
        }
        if((mat_act[i]& mat_tmp[3])!=0){
        fila=i-1;                                   //cambio de 2 a 1
        i=9;
        //command.printf("\n2- comparacion mat_act[i]& mat_tmp[2] :\n %d",mat_act[i]& mat_tmp[2]);
        }
        if((mat_act[i]& mat_tmp[2])!=0){            //se condicionan las salidas de la busqueda de lanueva fila
        fila=i;                                   //cambio de 2 a 1
        i=9;
        //command.printf("\n3- comparacion mat_act[i]& mat_tmp[1] :\n %d",mat_act[i]& mat_tmp[1]);
        }
        if((mat_act[i]& mat_tmp[1])!=0){
        fila=i+1;                                   //cambio de 2 a 1
        i=9;
        //command.printf("\n4- comparacion mat_act[i]& mat_tmp[0]:\n %d",mat_act[i]& mat_tmp[0]);
        }
    }
    if(fila>8)
    fila=8;
    if(fila==0){
    borrar();
    fila=8;
    }
    command.printf("\n buscar fila \n %d",fila);
    command.printf("\n ******************************* \n ");
};

void guardar_mat(){
        mat_act[fila-3]=mat_tmp1[0];
        mat_act[fila-2]=mat_tmp1[1];
        mat_act[fila-1]=mat_tmp1[2];     //pasa de 0 a -1
        mat_act[fila]=mat_tmp1[3];       //pasa de +1 a 0
    };
    
void correr_fig(){
    uint8_t correr=0;
    correr=command.getc();
    command.printf("\n4- Correr: %d",correr);
    if(correr==30)  //Arriba, voltear figura.
    correr=1;
    if(correr==29)  //izquierda, correr la figura.
    correr=2;
    if(correr==28)  //Derecha correr la figura.
    correr=3;
    switch (correr){
                case 0:
                break;  //cae la figura;
                case 1:
                grados++;
                if(grados>4)
                grados=1;
                break;  //Girar la figura;
                case 2:
                ncolumna++;
                if(ncolumna>7)
                ncolumna=7;
                break;  //correr a la Derecha;
                case 3:
                ncolumna--;
                if(ncolumna<1)
                ncolumna=1;
                break;  //correr a la izquierda;
                }
    
    }


void imp_mat(uint8_t *temp){                             //se genera la variable global cont.
            mat_tmp1[0]=(mat_tmp[0]+ mat_act[cont-3]);
            mat_tmp1[1]=(mat_tmp[1]+ mat_act[cont-2]);
            mat_tmp1[2]=(mat_tmp[2]+ mat_act[cont-1]);
            mat_tmp1[3]=(mat_tmp[3]+ mat_act[cont]);         //condicionador de funcion, se descarta por una funcion smart.                     
            sendSPI(cont-3,mat_tmp1[0]);
            sendSPI(cont-2,mat_tmp1[1]);
            sendSPI(cont-1,mat_tmp1[2]);
            sendSPI(cont  ,mat_tmp1[3]);                    //pasa de i+2 a i+1
            wait_ms(VEL);
}

void dibujar(char type_fig,char grados,char columna)
{    
    switch (type_fig){                  //Se envia el vector que contiene la figura a la funcion copiar matriz.
        case 1: if(columna>7)
                columna=7;
                cop_mat(5,1,1,FIG_ALL,columna); break;  //1: cuadro;
        
        case 2: if(grados==1 || grados==3)              
                cop_mat(0,0,0,FIG_ALL,columna);
                if(grados==2 || grados==4)
                cop_mat(5,5,2,FIG_ALL,columna);         //2: I;    
                break;
                  
        case 3: if(grados==1)
                cop_mat(0,0,1,FIG_ALL,columna);         //3: L; 
                if(grados==2)
                cop_mat(5,2,0,FIG_ALL,columna);
                if(grados==3)
                cop_mat(1,3,3,FIG_ALL,columna);
                if(grados==4)
                cop_mat(5,6,2,FIG_ALL,columna);
                break;                                  //2: I;
        
        case 4: if(grados==1)
                cop_mat(5,3,2,FIG_ALL,columna);         //4: T;
                if(grados==2)
                cop_mat(0,1,0,FIG_ALL,columna);
                if(grados==3)
                cop_mat(5,2,3,FIG_ALL,columna);
                if(grados==4)
                cop_mat(3,1,3,FIG_ALL,columna);
                break;
        
        case 5: if(grados==1 || grados==3)
                cop_mat(5,4,1,FIG_ALL,columna);   //5: S; 
                if(grados==2 || grados==4)
                cop_mat(0,1,3,FIG_ALL,columna);
                break; 
    }  
}

void fichas(){
    ficha= rand() % 5+1; 
    grados= rand() % 4+1;
    ncolumna=3; 
    }

int main() {
    test();
    borrar();
    while(1){
        fichas();
            buscar_fil();
            for (cont=0;cont<=fila;cont++){
                correr_fig();    
                dibujar(ficha,grados,ncolumna);
                buscar_fil();
                imp_mat(mat_tmp);
                }
            guardar_mat();   
        }
    }