
#ifndef SIGNALGENDEFS_H
#define SIGNALGENDEFS_H

/// Signal Generator Modes
///
/// This defines the modes. However, SG_KEYPAD is not an mode,
/// it is a proprietary mechanism used for displaying the keypad, and
/// is not intended to be used by the application.
///
typedef enum {
    SG_SINE,        ///< Sine wave
    SG_SQUARE,      ///< Square wave
    SG_TRIANGLE,    ///< Triangle wave
    SG_SAWTOOTH,    ///< Sawtooth
    SG_USER,        ///< User defined waveform
    SG_KEYPAD,      ///< This is an internal value, not for applications
    SG_START,       ///< This is the start/stop/pulse button
} SG_Waveform;

#endif // SIGNALGENDEFS_H
