#include "M5451.h"
#include "mbed.h"

M5451::M5451(PinName dataPin, PinName clockPin):
    _dataPin(dataPin), _clockPin(clockPin) {
    _state = 0ULL;
}

short M5451::outputs() {
    return JIRRICK_M5451_OUTPUTS;
}

void M5451::setState(uint64_t state){
    _state = state;
}

void M5451::setBit(short position, short value){
    if (position >= 0 && position < JIRRICK_M5451_OUTPUTS)
    {
        uint64_t value64 = value;
        _state = (_state & ~(1ULL << position)) | (value64 << position);
    }
}

void M5451::toggleBit(short position){
    if (position >= 0 && position < JIRRICK_M5451_OUTPUTS)
    {
        _state ^= 1ULL << position;
    }
}

void M5451::setAllBits(short value){
    for(short i = 0; i < JIRRICK_M5451_OUTPUTS; i++){
        setBit(i, value);
    }
}

void M5451::update() {
    _send(1); //START BIT
    uint64_t input = _state;
    for(short i = 0; i < JIRRICK_M5451_OUTPUTS; i++){
        short value = (input & 1ULL);
        _send(value);
        input = input >> 1;
    }
}

uint64_t M5451::getState() {
    return _state;
}

void M5451::_send(short bit) {
    _dataPin = (bit % 2);
    wait_us(JIRRICK_M5451_WAIT);
    _clockPin = 1;
    wait_us(JIRRICK_M5451_WAIT);
    _clockPin = 0;
    wait_us(JIRRICK_M5451_WAIT);
}

