#ifndef JIRRICK_M5451_H
#define JIRRICK_M5451_H
 
#include "mbed.h"

#define JIRRICK_M5451_WAIT      1
#define JIRRICK_M5451_OUTPUTS   35
 
class M5451 {
public:
    M5451(PinName dataPin, PinName clockPin);
    short outputs();
    void setState(uint64_t state);
    void setBit(short position, short value);
    void toggleBit(short position);
    void setAllBits(short value);
    void update();
    uint64_t getState();
  
private:  
    DigitalOut _dataPin;
    DigitalOut _clockPin;
    uint64_t _state;
    void _send(short bit);
};
 
#endif