/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "freetronicsLCDShield.h"

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);
AnalogIn analog_value(A0);

#define MV(x) ((0xFFF*x)/3300)
#define V25 1.398
#define SLOPE 0.0043

int main()
{
    wait(0.1);

    freetronicsLCDShield lcd(D6, D7, D2, D3, D4, D5, D8, A1);
    // turn on the back light (it's off by default)
    lcd.setBackLight(true);


    
  
    
    
    
    // print the first line and wait 3 sec
    lcd.cls();

    int i = 1;
    float meas=0;
    float LP=0.025;
    float LPT=0.0025;
    float temp=0;
    lcd.setCursorPosition(0, 0);
    lcd.printf("Napeti");
    ADC1->CR2|=ADC_CR2_TSVREFE;
    while(1) {
        meas = LP*analog_value.read()+(1-LP)*meas; // Converts and read the analog input value
        
    ADC_RegularChannelConfig(ADC1, 16, 1, ADC_SampleTime_7Cycles5);
    
   //// Temperature (in °C) = {(V25 - VSENSE) / Avg_Slope} + 25.
   //v25 = 1.43
   //avg_slope 4.3mv/c

    ADC_SoftwareStartConvCmd(ADC1, ENABLE); // Start conversion

    while (ADC_GetFlagStatus(ADC1, ADC_FLAG_EOC) == RESET); // Wait end of conversion

    temp= LPT*((V25-(float)(ADC_GetConversionValue(ADC1))*3.3/4096)/SLOPE+25)+(1-LPT)*temp; // Get conversion value
          
        
        if(meas > 0.5) { // If the value is greater than 1000 mV toggle the LED
            myled = 1;
        } else {
            myled = 0;
        }
        i++;
        if(i==200) {
            i=0;
            lcd.setCursorPosition(0, 0);
            lcd.printf("%2.2f C ", temp);
            lcd.setCursorPosition(1, 0);
            lcd.printf("%1.4f V", meas*3.3);
        }
        wait(0.001);
    }
}
