#include "mbed.h"

SPI spimaster(SPI1_MOSI, SPI1_MISO, SPI1_SCK);
DigitalOut cs(SPI1_CS);
Serial pc(USBTX,USBRX); 
int main() 
{
    
    pc.baud(115200);
    pc.printf("TTN mDot LoRa Temperature sensor starting ... \r\n");
    
    printf("\r\nDummy print");
    int response;
    // Chip must be deselected
    cs = 1;
 
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spimaster.format(8,0);
    spimaster.frequency(1000000);
    while(true)
    {
        // Select the device by seting chip select low
        cs = 0;
    
        // Send a dummy byte to receive response from the slave
        response = spimaster.write(0x1);
        response = spimaster.write(0x2);
        response = spimaster.write(0x3);
        response = spimaster.write(0x4);
        response = spimaster.write(0x5);
        response = spimaster.write(0x6);
        response = spimaster.write(0x7);
        response = spimaster.write(0x8);
        
        printf("\r\nSlave response = 0x%X", response);
 
        // Deselect the device
        cs = 1;
        wait(1);
     }   
}