#include "mbed.h"
#include "motordriver.h"
#include "rtos.h"
#include "stdio.h"
#include "SDFileSystem.h"
#include "wave_player.h"

volatile bool alarm = false;
DigitalOut led3(LED3);
DigitalOut led4(LED4);

RawSerial pi(USBTX, USBRX);
      
Motor wingL(p22, p9, p10, 1); // pwm, fwd, rev
Motor wingR(p21, p12, p11, 1);//wings move in opposite directions
//reverse one motor's leads when wiring
Motor wheelL(p24, p14, p13, 1);
Motor wheelR(p25, p16, p15, 1);//wheels move in the same direction
PwmOut led1(p23);
PwmOut led2(p26);

SDFileSystem sd(p5, p6, p7, p8, "sd");
AnalogOut DACout(p18);
wave_player waver(&DACout);
Mutex spk_mutex;
Mutex servo_mutex;
Mutex wing_mutex;
Mutex alrm_mutex;
Thread t2;
Thread t3;
Thread t4;
Thread t5;

InterruptIn interrupt(p27);
bool getAlarm() {
    return alarm;
}
void changeAlarm()
{
    while(true)
    {
        alarm = !alarm;
    }
}

void flapWings()
{
    bool flag;
    while(true) 
    {   
        flag = getAlarm();
        if(flag)
        {
            for (float s= -1.0; s < 0.0 ; s += 0.001)
            {
                wingL.speed(s);
                wingR.speed(s);
                wait(0.001);
            }
            for (float s= 1.0; s > 0.0 ; s -= 0.001)
            {
                wingL.speed(s);
                wingR.speed(s);
                wait(0.001);
            }
        }
        Thread::wait(100);//frequency of cycles of wing movemnets
    }
}

void playSound()
{
    FILE *wave_file;
    bool flag;
    while(true) 
    {   
    flag = getAlarm();
        if(flag)
        {
            led4 = 1;
            spk_mutex.lock();
            wave_file=fopen("/sd/sound01.wav","r");
            spk_mutex.unlock();
            
            waver.play(wave_file);
            
            spk_mutex.lock();
            fclose(wave_file);
            spk_mutex.unlock();
        }
        else if(!flag)
        {
            led4 = 0;
            DACout=0;
        }
        Thread::wait(500); 
    }
}

void stopAllOutputDevices() {
    wingL.stop(.5);
    wingR.stop(.5);
    wheelL.stop(.5);
    wheelR.stop(.5);
    led1=0;
    led2=0;
    
}

int readPiChar() {
    char temp;
    temp = pi.getc();
            
    led3 = !led3;
    alrm_mutex.lock();
    if(temp == '1') { 
        alarm = 1;
        led4 = 1;
        
        led1 = 1;
        led2= 1;
        return 1;
                
                // pi communicates directly to led4 via usb cable...
                // can pi also output to a pin?       

    }
    if(temp == '0') {
        alarm = 0;
        led1 = 0;
        led2= 0;
        led4 = 0;
        return 0;
    }
    alrm_mutex.unlock();
}

void testLED()
{
     while(true) 
    {
        if(readPiChar())
        {
            led1 = 1;
            led2= 1;
        }
        else
        {
        }
        Thread::wait(500);
    }
}

void dev_recv()
{
    char temp = 0;
    while(true)
    {
        while(pi.readable())
        {
            
            //pi.putc(1);
            temp = pi.getc();
            
            led3 = !led3;
            alrm_mutex.lock();
            if(temp == '1') { 
                alarm = 1;
                led4 = 1;
                //flapWings();
                //moveWheels();
                // pi communicates directly to led4 via usb cable...
                // can pi also output to a pin?       

            }
            if(temp == '0') {
                alarm = 0;
                led4 = 0;
                stopAllOutputDevices();
            }
            alrm_mutex.unlock();
        }
    Thread::wait(1000);
    }
}
void moveWheels()
{
    while(true)
    {
        if(readPiChar())
        {
            for (float i= -1.0; i < -0.9 ; i += 0.05)
            {
                wheelL.speed(i);
                wheelR.speed(i);
                wait(1);
            }
            wheelL.stop(0.5);
            wheelR.stop(0.5);
            for (float j= 1.0; j > 0.9 ; j -= 0.05)
            {
                wheelL.speed(j);
                wheelR.speed(j);
                wait(1);
            }
            wheelL.stop(0.5);
            wheelR.stop(0.5);
        }
    Thread::wait(200);//frequency of cycles of wing movemnets
    }
}

void setAlarm() {
    alarm = 1;
    // set led and sound
    
}
void clearAlarm() {
    alarm = 0;
    

    }
int main() 
{
    pi.baud(9600);
    //pi.attach(&piDetectInvader, Serial::RxIrq);
    //pi.attach(&dev_recv, Serial::RxIrq);
    //t2.start(testLED);
    //t1.start(changeAlarm);
    t3.start(flapWings);
    t4.start(moveWheels);
    //t5.start(playSound);
    //may not even need threads......
    interrupt.rise(&setAlarm);
    interrupt.fall(&clearAlarm);
    while(pi.readable()) 
    {       // main is the next thread
        Thread::wait(1000); // wait 2 seconds. Acknowledge pi that mbed is ready
    } 
}
