#include "mbed.h"
#include <string>
#include "ISM43362Interface.h"
#include "LSM6DSLSensor.h"
#include "HTS221Sensor.h"
#include "MQTTNetwork.h"
#include "MQTTClient.h"
#include "MQTTmbed.h"
#include "MbedJSONValue.h"
char* hostname = "192.168.22.165";
int port = 1883;
#define QOS      MQTT::QOS0
DigitalOut led(LED3);
int main()
{   
    Serial pc(SERIAL_TX, SERIAL_RX);
    char exchangebuf[50];
    ThisThread::sleep_for(10000);
    printf("start!");
    DevI2C I2C(PB_11, PB_10);
    LSM6DSLSensor Lsm(&I2C, 0xD4);
    HTS221Sensor Hts(&I2C, 0xBE);
    void* init;
    int ret;
    ret = Hts.init(init);
    if (0 == ret)
    {
        printf("init_hts succeed!!\n "); 
    }
    else
    {
        printf("init_hts failed!!\n");
        return -1; 
    }
    ret = Hts.enable();
    if (0 == ret)
    {
        printf("enable_hts succeed!!\n "); 
    }
    else
    {
        printf("enable_hts failed!!\n");
        return -1; 
    }
    ret = Lsm.init(init);
    if(0 == ret)
    {
        printf("init succeed!!\n"); 
    }
    else
    {
        printf("init failed!!\n"); 
        return -1;
    }
    ret = Lsm.enable_x();
     if(0 == ret)
    {
        printf("enable succeed!!\n"); 
    }
    else
    {
        printf("enable failed!!\n");
        return -1; 
    }
    ret = Lsm.set_x_odr(400.0);
     if(0 == ret)
    {
        printf("set_x_odr succeed!!\n"); 
    }
    else
    {
        printf("set_x_odr failed!!\n");
        return -1; 
    }   
    ret = Lsm.set_x_fs(8.0);
    if(0 == ret)
    {
        printf("set_x_fs succeed!!\n"); 
    }
    else
    {
        printf("set_x_fs failed!!\n");
        return -1; 
    }  
    ISM43362Interface net(PC_12,PC_11,PC_10,PE_0,PE_8,PE_1,PB_13);
    ret = net.connect("Google_2.4G","abcd1234",NSAPI_SECURITY_NONE);
    if(0 == ret)
    {
           printf("connect wifi succeed ip = %s\n",net.get_ip_address());    
    }
    else
    {
        printf("connect wifi failed!!!");
        return -1;
    }
    NetworkStack* network = &net;
    MQTTNetwork mqttNetwork(network);
    MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);
    ret = mqttNetwork.connect(hostname, port);
    client.connect();
    if (0 == ret)
    {
        printf("connect succeed!!\n");
    }
    else
    {
        printf("connect failed!!\n");
    }  
    MQTT::Message message;
    message.qos = QOS;
    message.retained = false;
    message.dup = false;
    string str;
    while(1)
    {       
        memset(exchangebuf, 0, sizeof(exchangebuf));
        float hum,temp;
        ret = Hts.get_temperature(&temp);
        if(ret != 0)
        {
            printf("get_temperature failed!\n"); 
        }
        MbedJSONValue value;
        value["temp"] = (int)temp;
        str = value.serialize();
        message.payload = (void*)str.c_str();
        message.payloadlen = str.size();
        int rc = client.publish("temp", message);
        printf("rc ==== %d",rc);
        ret = Hts.get_humidity(&hum);
        if(ret != 0)
        {
            printf("get_humidity failed!\n"); 
        }
        printf("hum = %.2f temp = %.2f\n", hum, temp); 
        str.clear();
        MbedJSONValue value_hum;
        value_hum["hum"] = (int)hum;
        str = value_hum.serialize();
        message.payload = (void*)str.c_str();
        message.payloadlen = str.size();
        rc = client.publish("hum", message);
        printf("rc ==== %d",rc);
        str.clear();
        int32_t buf[3];
        ret = Lsm.get_x_axes(buf);
        if(0 == ret)
        {
            printf("get_x_axes succeed!!\n"); 
        }
        else
        {
            printf("get_x_axes failed!!\n");
            return -1; 
        } 
        printf("x = %d y = %d z = %d\n",buf[0]/1000,buf[1]/1000,buf[2]/1000);
        MbedJSONValue value_xyz;
        value_xyz["x"] = buf[0]/1000;
        value_xyz["y"] = buf[1]/1000;
        value_xyz["z"] = buf[2]/1000;
        str = value_xyz.serialize();
        message.payload = (void*)str.c_str();
        message.payloadlen = str.size();
        rc = client.publish("xyz", message);
        ThisThread::sleep_for(10);
    }  
}
