#ifndef _MQTTNETWORK_H_
#define _MQTTNETWORK_H_

#include "NetworkInterface.h"

class MQTTNetwork {
public:
    MQTTNetwork(NetworkStack* aNetwork) : network(aNetwork) {
        socket = new TCPSocket();
    }

    ~MQTTNetwork() 
    {
        delete socket;
    }

    int read(unsigned char* buffer, int len, int timeout) {
        return socket->recv(buffer, len);
    }

    int write(unsigned char* buffer, int len, int timeout) {
        return socket->send(buffer, len);
    }

    int connect(const char* hostname, int port) {
        int ret = socket->open(network);
        printf("ret ===%d\n\n\n",ret);
        ret = socket->connect(hostname, port);
        printf("ret ======== %d\n\n\n", ret);
        return ret;
    }

    int disconnect() {
        return socket->close();
    }

private:
    NetworkStack* network;
    TCPSocket* socket;
};

#endif // _MQTTNETWORK_H_
