/**
    * @file comms.h
    * Header file for comms.cpp
    * A simplistic communication profile for streaming data sampled
    * from sensors over UART->radio->UART->dislpay
    *
    * @brief Header file for comms.cpp
    *
    * @author James A C Patterson
 */
#ifndef COMMS_H
#define COMMS_H

#define MAX_PACKET_SIZE 64

#define PORT_BASE (1<<13)
#define PROTOCOL 17

typedef struct header {
    uint16_t src_port;
    uint16_t dst_port;
    uint16_t length;
    uint16_t checksum;
} header_t;


typedef uint8_t packet_t[MAX_PACKET_SIZE];

typedef struct pseudo_header {
    uint32_t src_addr;
    uint32_t dst_addr;
    uint16_t protocol;
    uint16_t length;
    uint16_t checksum;
} pseudo_header_t;

/**
 * A class to implement a basic transport layer that is based very
 * loosely on UDP/UDP-lite
 */
class Transport {
public:
    Transport (uint32_t, uint32_t, uint32_t);
    void get_packet (uint8_t**,uint16_t*);
    void load_data (uint16_t*,uint16_t);
    void set_dst_port (uint16_t);
private:
    pseudo_header_t pseudo_header_;
    header_t header_;
    packet_t packet_;
};

#endif