#include "mbed.h"
#include "daq.h"
#include "comms.h"

#define NODE_ID 1
#define SAMPLE_PERIOD_US 20000
#define EXT_BIAS_VOLTAGE 0.1

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
Serial radioUART(p13,p14);
DigitalOut rst(p29);
DigitalOut en_mux_EXT(p29);
BusOut mux_EXT(p23,p24);
AnalogOut bias_EXT(p18);

ADC_BURST adc;
Decimator dec_0(5);
Decimator dec_1(5);
Decimator dec_2(5);
Decimator dec_3_0(5);
Decimator dec_3_1(5);
Decimator dec_3_2(5);
Decimator dec_3_3(5);
Ticker sampler;

Transport transmission(0xC0A80001, 0xC0A80000, NODE_ID);

uint8_t* radio_ptr = NULL;
uint16_t radio_len = 0;

uint8_t ext_mux_channel = 0;
bool waiting = false;

/**
 *  Collects sample from multiple sensor sources.
 *  Create a packets of samples from multiple sensor and pack
 *  them into a single, synchronised (via decimators) packet.
 */
void pack_samples_ISR() {
    uint16_t syncd_samples[7];
    syncd_samples[0] = dec_0.read();
    syncd_samples[1] = dec_1.read();
    syncd_samples[2] = dec_2.read();
    syncd_samples[3] = dec_3_0.read();
    syncd_samples[4] = dec_3_1.read();
    syncd_samples[5] = dec_3_2.read();
    syncd_samples[6] = dec_3_3.read();
    transmission.load_data(syncd_samples, 7);
    waiting = true;
}

void adc_ISR() {
    // Toggle a LED for visual feedback of activity
    myled = !myled;
    // Send the latest set of samples to the decimators
    dec_0.write((uint16_t)(adc.data[0] >> 4));
    dec_1.write((uint16_t)(adc.data[1] >> 4));
    dec_2.write((uint16_t)(adc.data[2] >> 4));
    switch (ext_mux_channel)  {
        case 0:
            dec_3_0.write((uint16_t)(adc.data[3] >> 4));
            break;
        case 1:
            dec_3_1.write((uint16_t)(adc.data[3] >> 4));
            break;
        case 2:
            dec_3_2.write((uint16_t)(adc.data[3] >> 4));
            break;
        case 3:
            dec_3_3.write((uint16_t)(adc.data[3] >> 4));
            break;
        default:
            error("Random multiplexer channel: %d!\n",ext_mux_channel);
    }
    // Select the next channel on the external multiplexer
    if (++ext_mux_channel == 4) ext_mux_channel = 0;
    mux_EXT = ext_mux_channel;
}

int main() {
    // Set up UART interface over USB
    pc.baud(115200);

    // Set up UART interface to radio module node
    // - CTS1 is set to DIP12 = port0.17
    LPC_PINCON->PINSEL1 &=     ~((uint32_t)0x3 << 2);
    LPC_PINCON->PINSEL1 |=      ((uint32_t)0x1 << 2);
    // - CTS1 is given a weak pull-up
    LPC_PINCON->PINMODE1 &=    ~((uint32_t)0x3 << 2);
    // - Enable autocts mode on UART1
    LPC_UART1->MCR |= (1 <<7 );
    // - Baud rate set fairly high
    radioUART.baud(115200);

    // Reset the radio board and wait a while for it to boot
    rst = 0;
    rst = 1;
    wait(0.25);

    // Attach a function to the sample period ticker
    // - this will enable continuous sampling of the ADC
    sampler.attach_us(&pack_samples_ISR, SAMPLE_PERIOD_US);

    // Set up the external analogue circuitry
    bias_EXT = EXT_BIAS_VOLTAGE;
    en_mux_EXT = 1;
    mux_EXT = ext_mux_channel;
    
    // Set up any remaining comm's

    // Choose which function to process the latest ADC values
    adc.attach(&adc_ISR);


    while (1) {
        if (waiting) {
            
            transmission.get_packet(&radio_ptr, &radio_len);
            //radioUART.attach(&uartISR,Serial::TxIrq);
            while (radio_len-- != 0) {
                radioUART.putc(*radio_ptr++);
            }
            pc.printf("C = %d\n",radio_len);
            waiting = false;
        }
    }
}
