/**
    * @file daq.h
    * Header file for daq.cpp - a data acquisition system capable of
    * sampling from multiple ADCs in BURST mode to allow consistent,
    * high-rate sampling. The samples are passed to a bank of decimators
    * to allow the samples to be synchronised with another, slower
    * sampling clock or other sampling sources/
    *
    * @brief Header file for daq.cpp
    *
    * @author James A C Patterson
 */
#ifndef DAQ_H
#define DAQ_H

typedef void (*FuncPtr)(void);

class ADC_BURST {
public:
    ADC_BURST ();
    ~ADC_BURST ();
    void attach(FuncPtr);
    void burst_isr(void);
    uint32_t data[4];
private:
    FuncPtr isr_pointer_;
    bool attached_;
    static ADC_BURST *instance;
    static void _burst_isr(void);
};

/**
 *  Decimator class to implement simple low-pass filtering on uC
 *  Unsigned integer decimator. Depth up to 32 samples.
 *  Currently just behaves as a uniform weighted FIR
 */
class Decimator {
public:
    Decimator (uint8_t);
    void write (uint16_t);
    uint16_t read ();
private:
    uint8_t decimation_order_;
    uint8_t decimation_length_;
    uint8_t decimation_pointer_;
    uint16_t decimation_buffer_[32];
    uint32_t accumulator_;
};
#endif