/*
    SD21 - 21 Channel Servo Driver Module Library
    Copyright (c) 2011 Jim Herd
    
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/    
#ifndef     MBED_SD21_H
#define     MBED_SD21_H

#include    "mbed.h"

#define     SD21_I2C_ADDRESS    0xC2
#define     NOS_SD21_SERVOS       21

#define     SERVO16_1     0
#define     SERVO16_2     3

#define     SERVO8_1     63
#define     SERVO8_2     64

typedef struct {
    int angle;
    int init_angle;
    int speed;
} SD21_servo_state_t ;

/** SD21 class
 *
 * Allow access to an SD21 21-channel servo controller unit
 *
 * @code
 *        SD21  servo_control
 * @endcode
 */
class SD21 {
public:
    /** Constructor for the SD21 connected to specified I2C pins at a specific address
     *
     * 21 Channel Servo Driver Module
     *
     * @param   sda         I2C data pin
     * @param   scl         I2C clock pin
     * @param   i2cAddress  I2C address
     */
    SD21(PinName sda, PinName scl);

    /** Reset SD21 device to its power-on state
     */    
    void reset(void);

    /** set a single servo value and associated speed using the full 16-bit registers
     *
     * @param   servo_num     1 to 21
     * @param   angle         0 to 90 (degrees)
     * @param   speed         0 to 255
     */   
    void set_servo(int servo_num, int angle, int speed);

protected:
    I2C     _i2c;
    SD21_servo_state_t   servo_state[21];
    
    union {
        uint8_t  value8[4];
        uint16_t value16[2];
        uint32_t value32;
    } SD21_tmp_data;
};

#endif