#include "mbed.h"
#include "stm32f1xx_hal.h"
#include "TextLCD.h"
DigitalOut myled(LED1);
SPI device(PB_15, PB_14, PB_13,NC); // mosi, miso, sclk, ssel
CAN_HandleTypeDef hcan;
static CanTxMsgTypeDef        TxMessage;
I2C i2c(PB_9, PB_8);
/* CAN1 init function */
static void MX_CAN1_Init(void)
{
  hcan.Instance = CAN1;
  hcan.pTxMsg=&TxMessage;     //发送消?
  hcan.Init.Prescaler = 6;
  hcan.Init.Mode = CAN_MODE_LOOPBACK;
  hcan.Init.SJW = CAN_SJW_1TQ;
  hcan.Init.BS1 = CAN_BS1_8TQ;
  hcan.Init.BS2 = CAN_BS2_3TQ;
  hcan.Init.TTCM = DISABLE;
  hcan.Init.ABOM = DISABLE;
  hcan.Init.AWUM = DISABLE;
  hcan.Init.NART = DISABLE;
  hcan.Init.RFLM = DISABLE;
  hcan.Init.TXFP = DISABLE;
  if (HAL_CAN_Init(&hcan) != HAL_OK)
  {
    //Error_Handler();
  }
  
}
//       其他,失败;
uint8_t CAN1_Send_Msg(uint8_t* msg,uint8_t len)
{   
   uint16_t i=0;
    hcan.pTxMsg->StdId=0X12;        //标准标识?
    hcan.pTxMsg->ExtId=0X12;        //扩展标识?(29?)
    hcan.pTxMsg->IDE=CAN_ID_STD;    //使用标准?
    hcan.pTxMsg->RTR=CAN_RTR_DATA;  //数据?
    hcan.pTxMsg->DLC=len;                
    for(i=0;i<len;i++)
    hcan.pTxMsg->Data[i]=msg[i];
    if(HAL_CAN_Transmit(&hcan,10)!=HAL_OK) return 1;     //发?
    return 0;       
}



void HAL_CAN_MspInit(CAN_HandleTypeDef* hcan)
{

  GPIO_InitTypeDef GPIO_InitStruct;
  if(hcan->Instance==CAN1)
  {
  /* USER CODE BEGIN CAN1_MspInit 0 */

  /* USER CODE END CAN1_MspInit 0 */
    /* Peripheral clock enable */
    __HAL_RCC_GPIOA_CLK_ENABLE();
    __HAL_RCC_CAN1_CLK_ENABLE();
  
    /**CAN GPIO Configuration    
    PA11     ------> CAN_RX
    PA12     ------> CAN_TX 
    */
    GPIO_InitStruct.Pin = GPIO_PIN_11;
    GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
    GPIO_InitStruct.Pull = GPIO_NOPULL;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

    GPIO_InitStruct.Pin = GPIO_PIN_12;
    GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_HIGH;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /* USER CODE BEGIN CAN1_MspInit 1 */

  /* USER CODE END CAN1_MspInit 1 */
  }


}

int main() {
         int address = 0x62;
        char data[2];
    
     uint8_t canbuf[8]={1,2,3,4,5,6,7,8};
    MX_CAN1_Init();
   
    while(1) {
       CAN1_Send_Msg(canbuf,8);//发?8个字? 
       i2c.read(address, data, 2);
       device.write(0x55);
        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(1.0); // 1 sec
    }
}
