/*
 *  Copyright (c) 2012 Neal Horman - http://www.wanlink.com
 *  
 *  License: MIT open source (http://opensource.org/licenses/MIT)
 *      Summary;
 *      Use / modify / distribute / publish it how you want and 
 *      if you use it, or don't, you can't hold me liable for how
 *      it does or doesn't work.
 *      If it doesn't work how you want, don't use it, or change
 *      it so that it does work.
 */
 
#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "Adafruit_GFX.h"
#include "PinNames.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "hx711.h"

// Onboard LED 
DigitalOut led1(LED1);
DigitalOut led2(LED2);

// Control Buttons
DigitalIn sw_left(PTC8);
DigitalIn sw_right(PTC9);
DigitalIn sw_up(PTC0);
DigitalIn sw_down(PTC7);
DigitalIn sw_fire(PTC5);

// Mux Port for OLED Displays
BusOut MuxPortOut(PTB11, PTB2, PTB10, PTB3);

// Load Cell
HX711 load_cell(PTC2, PTA2); // clock, data_out

DigitalOut LCD_LED(PTC3); // the TFT display has a backlight switch

extern unsigned char p1[];  // the mbed logo 
// the TFT is connected to SPI pin 5-7
SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1, PTD0, PTC4, PTE26,"TFT"); // mosi, miso, sck, cs, reset, dc
 

// an SPI sub-class that provides a constructed default
class SPIPreInit : public SPI
{
public:
    SPIPreInit(PinName mosi, PinName miso, PinName clk) : SPI(mosi,miso,clk)
    {
        format(8,3);
        frequency(2000000);
    };
};
 
// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(800000);
        start();
        wait(0.1); // needed so that the displays initialise properly at power-on.
    };
};
 
//SPIPreInit gSpi(p5,NC,p7);
//Adafruit_SSD1306_Spi gOled1(gSpi,p26,p25,p24);
 
I2CPreInit gI2C(I2C_SDA,I2C_SCL);
//mux_SSD1306_I2c gOled1(gI2C,Reset_Pin,muxport, muxmask, 0, 0x78,64);

mux_SSD1306_I2c gOled1(gI2C,PTC16,MuxPortOut, 0, 0x78,64);
mux_SSD1306_I2c gOled2(gI2C,PTC16,MuxPortOut, 0, 0x7A,64);
mux_SSD1306_I2c gOled3(gI2C,PTC16,MuxPortOut, 1, 0x78,64);
mux_SSD1306_I2c gOled4(gI2C,PTC16,MuxPortOut, 1, 0x7A,64);
mux_SSD1306_I2c gOled5(gI2C,PTC16,MuxPortOut, 2, 0x78,64);
mux_SSD1306_I2c gOled6(gI2C,PTC16,MuxPortOut, 2, 0x7A,64);
mux_SSD1306_I2c gOled7(gI2C,PTC16,MuxPortOut, 3, 0x78,64);
mux_SSD1306_I2c gOled8(gI2C,PTC16,MuxPortOut, 3, 0x7A,64);
mux_SSD1306_I2c gOled9(gI2C,PTC16,MuxPortOut, 4, 0x78,64);




void testdrawline() {
    for (int16_t i=0; i<gOled1.width(); i+=4) {
        gOled1.drawLine(0, 0, i, gOled1.height()-1, WHITE);
        gOled1.display();
    }
    for (int16_t i=0; i<gOled2.height(); i+=4) {
        gOled2.drawLine(0, 0, gOled2.width()-1, i, WHITE);
        gOled2.display();
    }
    for (int16_t i=0; i<gOled3.height(); i+=4) {
        gOled3.drawLine(0, 0, gOled3.width()-1, i, WHITE);
        gOled3.display();
    }
    for (int16_t i=0; i<gOled4.width(); i+=4) {
        gOled4.drawLine(0, 0, i, gOled4.height()-1, WHITE);
        gOled4.display();
    }
    for (int16_t i=0; i<gOled5.width(); i+=4) {
        gOled5.drawLine(0, 0, i, gOled5.height()-1, WHITE);
        gOled5.display();
    }
    for (int16_t i=0; i<gOled6.width(); i+=4) {
        gOled6.drawLine(0, 0, i, gOled6.height()-1, WHITE);
        gOled6.display();
    }
    for (int16_t i=0; i<gOled7.width(); i+=4) {
        gOled7.drawLine(0, 0, i, gOled7.height()-1, WHITE);
        gOled7.display();
    }
    for (int16_t i=0; i<gOled8.width(); i+=4) {
        gOled8.drawLine(0, 0, i, gOled8.height()-1, WHITE);
        gOled8.display();
    }
    for (int16_t i=0; i<gOled9.width(); i+=4) {
        gOled9.drawLine(0, 0, i, gOled9.height()-1, WHITE);
        gOled9.display();
    }

}


 
int main()
{
    // Set our input buttons to pull-up mode
    sw_left.mode(PullUp);
    sw_right.mode(PullUp);
    sw_up.mode(PullUp);
    sw_down.mode(PullUp);
    sw_fire.mode(PullUp);
    
// ILI9341 Test Routine
    int i;
    LCD_LED = 1;  // backlight on
   
    TFT.claim(stdout);      // send stdout to the TFT display
    //TFT.claim(stderr);      // send stderr to the TFT display
    TFT.set_orientation(1);
    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();                // clear the screen
 
    //first show the 4 directions
    TFT.set_orientation(0);
    TFT.background(Black);
    TFT.cls();
 
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(0,0);
    TFT.printf(" Hello Mbed 0");
    TFT.set_orientation(1);
    TFT.locate(0,0);
    TFT.printf(" Hello Mbed 1");
    TFT.set_orientation(2);
    TFT.locate(0,0);
    TFT.printf(" Hello Mbed 2");
    TFT.set_orientation(3);
    TFT.locate(0,0);
    TFT.printf(" Hello Mbed 3");
    TFT.set_orientation(2);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(5,100);
    TFT.printf("The Mixologist");

// draw some graphics
    TFT.cls();
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(5,100);
    TFT.printf("The Mixologist");
 
    TFT.line(0,0,100,0,Green);
    TFT.line(0,0,0,200,Green);
    TFT.line(0,0,100,200,Green);
 
    TFT.rect(100,50,150,100,Red);
    TFT.fillrect(180,25,220,70,Blue);
 
    TFT.circle(80,150,33,White);
    TFT.fillcircle(160,190,20,Yellow);
 
    double s;
 
    for (i=0; i<320; i++) {
        s =20 * sin((long double) i / 10 );
        TFT.pixel(i,100 + (int)s ,Red);
    }
    TFT.set_orientation(2);
    TFT.set_font((unsigned char*) Arial24x23);
    
/*   // bigger text
    TFT.foreground(White);
    TFT.background(Blue);
    TFT.cls();
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(0,0);
    TFT.printf("Different Fonts :");
 
    TFT.set_font((unsigned char*) Neu42x35);
    TFT.locate(0,30);
    TFT.printf("Hello Mbed 1");
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.locate(20,80);
    TFT.printf("Hello Mbed 2");
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(35,120);
    TFT.printf("Hello Mbed 3");
*/

 // start of OLED Code   
    uint16_t x=0;
    uint16_t y=65535;
    long a=16348;
    uint16_t b=49152;
    led1=1;
    led2=1;

    gOled1.clearDisplay();
    gOled2.clearDisplay();
    gOled3.clearDisplay();
    gOled4.clearDisplay();
    gOled5.clearDisplay();    
    gOled6.clearDisplay();    
    gOled7.clearDisplay();    
    gOled8.clearDisplay();    
    gOled9.clearDisplay();    
    
    testdrawline();

    gOled1.clearDisplay();
    gOled2.clearDisplay();
    gOled3.clearDisplay();
    gOled4.clearDisplay();
    gOled5.clearDisplay();
    gOled6.clearDisplay();
    gOled7.clearDisplay();
    gOled8.clearDisplay();
    gOled9.clearDisplay();
 
    gOled1.printf("      Aqua Vega A \r\n\n\n\n", gOled1.width(), gOled1.height());
    gOled2.printf("      Aqua Vega B \r\n\n\n\n", gOled2.width(), gOled2.height());
    gOled3.printf("      Cannazyme \r\n\n\n\n", gOled3.width(), gOled3.height());
    gOled4.printf("      Rhizotonic \r\n\n\n\n", gOled4.width(), gOled4.height());
    gOled5.printf("      Aqua Flores A \r\n\n\n\n", gOled5.width(), gOled5.height());
    gOled6.printf("      Aqua Flores B \r\n\n\n\n", gOled6.width(), gOled6.height());
    gOled7.printf("      PK13/14 \r\n\n\n\n", gOled7.width(), gOled7.height());
    gOled8.printf("      Cannaboost \r\n\n\n\n", gOled8.width(), gOled8.height());
    gOled9.printf("      pH-Down \r\n\n\n\n", gOled9.width(), gOled9.height());
    gOled1.setTextSize(2);
    gOled2.setTextSize(2);
    gOled3.setTextSize(1);
    gOled4.setTextSize(2);
    gOled5.setTextSize(2);
    gOled6.setTextSize(2);
    gOled7.setTextSize(2);
    gOled8.setTextSize(1);
    gOled9.setTextSize(2);

    TFT.cls();  
    while(1)
    {
        led1 = 0;
        gOled1.printf("  %uml\r",x);
        gOled1.display();
        gOled6.printf("  %uml\r",x);
        gOled6.display();
        led1 = 1;
        led2 = 0;
        gOled2.printf("  %uml\r",y);
        gOled2.display();
        gOled4.printf("  %uml\r",y);
        gOled4.display();
        gOled7.printf("  %uml\r",y);
        gOled7.display();
        gOled3.printf("  %uml\r",a);
        gOled3.display();
        gOled8.printf("  %uml\r",a);
        gOled8.display();
        gOled5.printf("  %uml\r",b);
        gOled5.display();
        gOled9.printf("  %uml\r",b);
        gOled9.display();
        led2 = 1;
        x++;
        y--;
        if ( sw_up == 0 ){
            a++;
        } 
        if ( sw_down == 0 ){
            a--;
        } 
        if ( sw_left == 0 ){
            a = load_cell.readData();
        } 
        
        b--;
        TFT.locate(10,80);
        TFT.foreground(65535);
        TFT.printf("A Value:%d",a);
        TFT.locate(10,120);
        TFT.foreground(65504);
        TFT.printf("B Value:%d",b);
        TFT.locate(10,160);
        TFT.foreground(2016);
        TFT.printf("X Value:%d",x);
        TFT.locate(10,200);
        TFT.foreground(05535);
        TFT.printf("Y Value:%d",y);
        //wait(0.1);
    }
}
