/* mbed library for HX711 Load Cell Amplifier/24-bit A/D converter
 * Copyright (c) 2015 Jim Conner
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
/** Some stuff to make the load cell work.
 */ 
 
#include "mbed.h"
 
#ifndef HX711_H
#define HX711_H

/* some definitiions go in here                                                */
//#define Black           0x0000      /*   0,   0,   0 */

// Load Cell control class
 class HX711 
 {
 public:

  /** Create an HX711 object connected to Clock and Data pins
   *
   * @param clk pin connected to clock line of HX711 board
   * @param addo pin connected to data line of HX711 board
   */ 
  HX711(PinName clk, PinName addo);
  ~HX711();
    
  /** Read data from the HX711 interface
   * @return reading from ADC as an int.
   */    
  long readData(void);
     
private:
  DigitalOut clk; 
  DigitalIn addo;  

};

#endif
