/* mbed library for HX711 Load Cell Amplifier/24-bit A/D converter
 * Copyright (c) 2015 Jim Conner
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "hx711.h"
#include "mbed.h"

//#define BPP         16                  // Bits per pixel    

// Constructor         
HX711::HX711(PinName clk, PinName addo) : clk(clk), addo(addo) 
{

    
}

// Destructor
HX711::~HX711(void) {}


// Reading data from the converter
long HX711::readData(void)
{
  unsigned char i;
  unsigned long Count;
  clk=0;
  Count=0;
  while(addo);
  for (i=0;i<24;i++) {
      clk=1;
      Count=Count<<1;
      clk=0;
      if(addo) Count++;
  }
  clk=1;
  Count=Count ^0x800000;
  clk=0;
  return(Count);
}

