/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LCD.h"


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

DigitalOut statusled(PC_0);
PortOut dieUebrigen(PortC,0b11111110);
PortIn schalterchen(PortB,0b11111111);
InterruptIn taste(PA_1);
AnalogIn poti(PA_0);
lcd meinLCD;

void isr()
{
    statusled=0;
}

int main()
{
    // Initialise the digital pin LED1 as an output
    int zaehler=0;
    float x;
    DigitalOut led(LED1);
    taste.mode(PullDown);
    taste.rise(&isr);
    taste.enable_irq();
    __enable_irq();
    meinLCD.clear();
    meinLCD.cursorpos(0x40);
    meinLCD.printf("Hallo Welt");
    statusled=1;
    schalterchen.mode(PullDown);
    while (true) {
        dieUebrigen=schalterchen;
        led = !led;
        zaehler++;
        if (poti>0.5) statusled=1;
        else statusled=0;
        x=poti;
        meinLCD.cursorpos(0);
        meinLCD.printf("Z= %d, poti=%f  ",zaehler,x);
        //if (taste) statusled=0;
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
