#include <mbed.h>
#include "DS18S20.h"
#include "DS18B20.h"
#include "uLCD_4DGL.h"
#include "OneWireDefs.h"
#define THERMOMETER DS18B20

PwmOut heat(p21);
Ticker heatflip;
uLCD_4DGL uLCD(p9, p10, p11);
DigitalOut led(p15);
Serial blue(p28,p27);

// device( crcOn, useAddress, parasitic, mbed pin )
THERMOMETER device(true, true, false, p25);

Ticker thermoUpdate;
float desiredTemp = 25.0; 
float currentTemp;
float heatVal = 0.0;

void updateThermometer(){
    currentTemp = device.readTemperature();
    }
void updateHeat(){
    if(desiredTemp < currentTemp){
        heatVal = 0.0;
        led = 0;
        }
       else{
        heatVal = 0.9 + (desiredTemp - currentTemp)/200.0;
        led = 1;
           } 
    heat = heatVal;
    }
    


int main()
{
    
    //uLCD.baudrate(3000000);
    uLCD.printf("STARTED0");
    while (!device.initialize());    // keep calling until it works
    uLCD.printf("STARTEDdevice");
    thermoUpdate.attach(&updateThermometer, 2.0);
    uLCD.printf("STARTEDthermo");
    heatflip.attach(&updateHeat, 5.0);
    uLCD.printf("STARTEDheat");
    uLCD.printf("STARTEDtemp");
    while (true)
    {           
        if(blue.readable()) {
          float num1 = ((float)(blue.getc()-'0') );
          float num2 = ((float)(blue.getc()-'0') );
          desiredTemp = num1 * 10 + num2;
        
        }
        uLCD.cls();
        uLCD.printf("The current temp is %.5f degrees celsius!\n The desired temp is %.5f degrees celsius!\n The heat is %.5f",currentTemp, desiredTemp, heatVal);
        wait(2);   
    }
    return EXIT_SUCCESS;
}
