/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds

Name: Jiaxin Zhou   
Username: Jiaxin Zhou     
Student ID Number: 201282650
Date:16/04/2019

*/

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Move.h"
#include "Menu.h"
/** @file main.cpp
 *  @brief This file is used to callback all functions.
 */

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Move move;
Menu menu;

void initial();
void welcome();
void render();
void menus(N5110 &lcd);
int input(int sel,Gamepad &pad);

///////////// MAIN.CPP ////////////////
int main () {
    int fps = 0; // initial fps, fps will be update by function menu.difficulty(lcd,pad).
    initial();
    welcome();
    menu.menus(lcd,pad);// settings or start game
    fps = menu.difficulty(lcd,pad);
    render();
    move.getfood(); // generate food 
    while(1) {

    move.eatfood();  //check is food is hit by snake head, if yes , generate a new one
    move.update(pad);
    move.updatebody();
    
    render();
    move.die(lcd,pad);
    wait(1.0f/fps);
    }
    
    
}

void initial() {
    lcd.init();
    pad.init();
    move.initial();
}

void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    move.onlcd(lcd);
    lcd.refresh();
}

void welcome() {
    lcd.printString("    snake!    ",0,1);  
    lcd.printString("( Press Start)",0,4);
    lcd.refresh();
    
        while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
        
}    