#ifndef MOVE_H
#define MOVE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Menu.h"



/** Snakebody struct */
struct SnakeBody{
    char _xx[4000];/**< char for x coordinate for each bit of snake body*/
    char _yy[4000];/**< char for x coordinate for each bit of snake body*/
    char _dir;/**< char for direction of snake hesd*/
    
    };
    
/** Food struct */
struct Food{
    char a;/**< char for x coordinate for food position*/
    char b;/**< char for y coordinate for food position*/
    
    };    
/** Move Class
@brief Class for main engine for the snake game
@author Zhou Jiaxin
@date 8th May 2019
*/

class Move
{
public:
    /** Constructor */
    Move();
    /** Destructor */
    ~Move();
    
    /** 
    * @brief initial all the parameter for the snake and food.
    */
    void initial();
    /** 
    * @brief Print snake, walls and food on LCD.
    * @param N5110 *lcd @details pointer to the N5110 object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    void onlcd(N5110 &lcd);
    /** 
    * @brief Update new direction and snake head.
    * @param Gamepad *pad @details pointer to the gamepad object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    void update(Gamepad &pad);
    /** 
    * @brief Update whole snakebody. 
    */
    void updatebody();
    /** 
    * @brief Use random number to generate a new food on screen while old food has benn eaten.
    */
    void getfood();
    /** 
    * @brief check if snake head collide the wall or its body.
    * @param N5110 *lcd @details pointer to the N5110 object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    * @param Gamepad *pad @details pointer to the gamepad object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    void die(N5110 &lcd ,Gamepad &pad);
    /** 
    * @brief check if snake head hit the food.
    */
    void eatfood();
    
private:

    int _x;
    int _y;
    int _length;
    Direction _d;
    Menu menu;
    int _fps;

};
#endif