#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Menu Class
@brief Class for settings and start game
@author Zhou Jiaxin
@date 8th May 2019
*/

class Menu 
{
public:
    /** Constructor */
    Menu();
    /** Destructor */
    ~Menu();
    
    /** 
    * @brief initial all the parameter for the snake and food.
    * @param select @details is used to switch the menu.
    * @param Gamepad *pad @details pointer to the gamepad object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    int input(int select,Gamepad &pad);
    /** 
    * @brief Main menu for settings and start game.
    * @param N5110 *lcd @details pointer to the N5110 object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    * @param Gamepad *pad @details pointer to the gamepad object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    void menus(N5110 &lcd,Gamepad &pad);
    /** 
    * @brief select difiiculty.
    * @param N5110 *lcd @details pointer to the N5110 object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    * @param Gamepad *pad @details pointer to the gamepad object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    * @returns fps @details is the frame per second, with higher fps means higher difficulty.
    */
    int difficulty(N5110 &lcd,Gamepad &pad);
   
    
private:
    int sel;
    int go_on;
    int _fps;
        

};

#endif