#include <math.h>
#include "Sprite.h"
#include "uLCD_4DGL.h"
#include "graphic.h"


extern uLCD_4DGL guLCD;
extern double gTimeStep;
extern double gOriginX;
extern double gOriginY;

Sprite::Sprite():
m_xCenter(gOriginX),
m_yCenter(gOriginY),
m_DirX(0.0), 
m_DirY(0.0),
m_Velocity(0.0),
m_color(WHITE),
m_RotationVelocity(0.0),
m_RotationDirection(NONE),
m_numPoints(0), 
m_bIsValid(false)
{
 
}
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
// move   
// Erase Sprite from current location
// Move the sprite to the new location 
// Draw sprite at new location
void Sprite::move()
{

    // Erase object
    draw(true);
 
    // Translate to the origin all points around the origin using the center points   
    for (int ii = 0 ; ii < m_numPoints ; ++ii)
    {
        m_xPoints[ii] -= m_xCenter;
        m_yPoints[ii] -= m_yCenter;
    }     
 
    // Rotate around the origin
    float tmpX, tmpY;
    for (int ii = 0 ; ii < m_numPoints ; ++ii)
    {
        tmpX = m_xPoints[ii]*std::cos(m_RotationVelocity*PI/180.0) - m_yPoints[ii]*std::sin(m_RotationVelocity*PI/180.0);
        tmpY = m_yPoints[ii]*std::cos(m_RotationVelocity*PI/180.0) + m_xPoints[ii]*std::sin(m_RotationVelocity*PI/180.0); 
        
        m_xPoints[ii] = tmpX;
        m_yPoints[ii] = tmpY;     
    }    
    // Translate back to original location
    for (int ii = 0 ; ii < m_numPoints ; ++ii)
    {
        m_xPoints[ii] += m_xCenter;
        m_yPoints[ii] += m_yCenter;
    }          
    // Move to new location
    for (int ii = 0 ; ii < (m_numPoints-1) ; ++ii)
    {
        m_xPoints[ii] += m_DirX*m_Velocity*(gTimeStep);
        m_yPoints[ii] += m_DirY*m_Velocity*(gTimeStep);
    } 
    m_xCenter += m_DirX*m_Velocity*(gTimeStep);
    m_yCenter += m_DirX*m_Velocity*(gTimeStep);
    // Draw at the new location    
    draw(false);
 
}
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
// draw sprite at new location
void Sprite::draw(bool bErase)
{
    int currentColor = BLACK;
    if (!bErase)
    {
        currentColor = m_color;
    }
    
    if (m_numPoints < 2)
    {
        return;
    }
    else if (m_numPoints == 2)
    {
        guLCD.line((int)m_xPoints[m_numPoints-1], (int)m_yPoints[m_numPoints-1] , (int)m_xPoints[0], (int)m_yPoints[0], currentColor);
    }
    else
    {         
        for (int ii = 0 ; ii < (m_numPoints-1) ; ++ii)
        {
            guLCD.line((int)m_xPoints[ii], (int)m_yPoints[ii] , (int)m_xPoints[ii+1], (int)m_yPoints[ii+1], currentColor);
        }
        // go from last point to first point
        guLCD.line((int)m_xPoints[m_numPoints-1], (int)m_yPoints[m_numPoints-1] , (int)m_xPoints[0], (int)m_yPoints[0], currentColor);
    }

}
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
// addPoint
// Adds a point to the vector of points
void Sprite::addPoint(int x, int y)
{
    m_xPoints[m_numPoints] = x;
    m_yPoints[m_numPoints] = y;
    m_numPoints++;
    if (m_numPoints == NUM_POINTS)
    {
        m_numPoints = 0;
    }
}

