/**********************************************************************
* Written by WAVToCode
* Date:				Sun Mar 28 09:07:41 AM
* FileName:			bangsmall.h
* Interleaved:		N/A
* Signed:			No
* No. of channels:	1
* No. of samples:	9557
* Bits/Sample:		8
**********************************************************************/

#define NUM_BANG_SMALL_ELEMENTS 9557

const unsigned char gBangSmallData[NUM_BANG_SMALL_ELEMENTS] = {
127, 126, 123, 125, 138, 153, 159, 155, /* 0-7 */
151, 156, 169, 180, 180, 173, 168, 162, /* 8-15 */
156, 150, 144, 137, 138, 149, 159, 170, /* 16-23 */
177, 180, 190, 198, 204, 203, 193, 186, /* 24-31 */
191, 197, 196, 183, 170, 167, 173, 176, /* 32-39 */
168, 154, 142, 130, 119, 107,  97,  87, /* 40-47 */
 77,  70,  61,  63,  74,  84,  83,  76, /* 48-55 */
 71,  67,  62,  58,  48,  42,  40,  37, /* 56-63 */
 40,  46,  45,  47,  47,  47,  47,  47, /* 64-71 */
 48,  49,  51,  52,  60,  79,  96, 113, /* 72-79 */
130, 146, 162, 176, 190, 202, 213, 223, /* 80-87 */
231, 239, 239, 228, 216, 212, 217, 220, /* 88-95 */
223, 222, 218, 221, 221, 222, 222, 219, /* 96-103 */
217, 214, 211, 209, 198, 176, 170, 169, /* 104-111 */
165, 148, 129, 111,  94,  78,  63,  49, /* 112-119 */
 36,  24,  13,   6,   8,  17,  27,  38, /* 120-127 */
 48,  56,  51,  45,  40,  35,  30,  25, /* 128-135 */
 22,  14,  11,  10,   9,  23,  42,  57, /* 136-143 */
 73,  88, 103, 118, 132, 144, 156, 168, /* 144-151 */
178, 186, 195, 202, 209, 213, 202, 189, /* 152-159 */
181, 185, 186, 188, 189, 191, 180, 163, /* 160-167 */
148, 148, 150, 152, 154, 157, 153, 137, /* 168-175 */
122, 116, 122, 119, 120, 124, 127, 134, /* 176-183 */
143, 146, 149, 153, 149, 134, 118, 112, /* 184-191 */
116, 118, 122, 125, 129, 132, 136, 136, /* 192-199 */
121, 106,  97, 102, 105, 109, 113, 117, /* 200-207 */
121, 124, 128, 132, 135, 135, 121, 105, /* 208-215 */
 97, 100, 104,  99,  84,  71,  71,  77, /* 216-223 */
 82,  81,  88,  94, 100, 113, 115, 103, /* 224-231 */
 91,  89,  97, 103, 110, 116, 122, 113, /* 232-239 */
101,  93,  99, 107, 108,  96,  87,  77, /* 240-247 */
 70,  64,  57,  51,  46,  40,  36,  32, /* 248-255 */
 32,  34,  36,  39,  42,  45,  52,  69, /* 256-263 */
 88, 106, 123, 127, 126, 129, 145, 161, /* 264-271 */
176, 190, 201, 208, 221, 231, 242, 251, /* 272-279 */
254, 251, 245, 237, 224, 213, 203, 192, /* 280-287 */
182, 173, 164, 155, 148, 141, 135, 130, /* 288-295 */
125, 124, 135, 149, 158, 154, 151, 156, /* 296-303 */
171, 183, 196, 208, 220, 230, 239, 245, /* 304-311 */
247, 245, 243, 241, 239, 232, 219, 206, /* 312-319 */
204, 209, 212, 217, 219, 217, 210, 196, /* 320-327 */
183, 171, 153, 144, 151, 155, 163, 173, /* 328-335 */
178, 183, 188, 190, 179, 167, 155, 144, /* 336-343 */
130, 125, 130, 134, 127, 113, 103, 105, /* 344-351 */
111, 117, 123, 129, 130, 118, 107, 103, /* 352-359 */
111, 116, 122, 128, 133, 138, 143, 145, /* 360-367 */
133, 120, 106,  94,  81,  76,  82,  87, /* 368-375 */
 93,  99, 105, 112, 118, 124, 129, 135, /* 376-383 */
134, 120, 107,  94,  82,  69,  67,  74, /* 384-391 */
 79,  84,  84,  88,  78,  67,  64,  55, /* 392-399 */
 46,  38,  30,  23,  17,  12,   9,   7, /* 400-407 */
  5,   5,  15,  30,  42,  40,  40,  40, /* 408-415 */
 41,  40,  51,  69,  85, 101, 117, 132, /* 416-423 */
147, 160, 173, 184, 195, 197, 188, 179, /* 424-431 */
182, 192, 199, 206, 211, 213, 201, 186, /* 432-439 */
176, 180, 183, 178, 163, 150, 136, 124, /* 440-447 */
112, 114, 121, 124, 115, 105,  96,  87, /* 448-455 */
 79,  78,  89,  98,  99,  84,  78,  73, /* 456-463 */
 67,  67,  67,  62,  60,  58,  56,  56, /* 464-471 */
 57,  57,  58,  59,  61,  62,  64,  69, /* 472-479 */
 87, 107, 121, 123, 124, 126, 128, 128, /* 480-487 */
139, 156, 172, 175, 173, 172, 170, 167, /* 488-495 */
169, 184, 196, 209, 221, 232, 233, 225, /* 496-503 */
219, 224, 234, 239, 243, 242, 240, 239, /* 504-511 */
233, 220, 208, 195, 193, 198, 202, 206, /* 512-519 */
209, 213, 211, 209, 206, 204, 201, 199, /* 520-527 */
197, 195, 193, 190, 189, 187, 185, 183, /* 528-535 */
182, 175, 154, 134, 114,  95,  77,  60, /* 536-543 */
 45,  31,  18,  19,  24,  28,  21,  12, /* 544-551 */
  9,  17,  27,  30,  23,  18,  22,  34, /* 552-559 */
 44,  43,  38,  35,  31,  28,  25,  22, /* 560-567 */
 20,  19,  18,  18,  18,  19,  20,  32, /* 568-575 */
 49,  64,  67,  68,  70,  72,  72,  80, /* 576-583 */
 96, 113, 119, 118, 119, 130, 145, 158, /* 584-591 */
171, 183, 195, 205, 209, 211, 203, 195, /* 592-599 */
191, 187, 178, 170, 162, 154, 147, 140, /* 600-607 */
136, 145, 154, 163, 171, 181, 180, 173, /* 608-615 */
168, 174, 183, 189, 182, 172, 166, 171, /* 616-623 */
176, 182, 186, 192, 187, 175, 165, 154, /* 624-631 */
143, 133, 123, 113, 107, 114, 121, 129, /* 632-639 */
135, 144, 142, 133, 126, 129, 137, 144, /* 640-647 */
151, 157, 160, 150, 140, 131, 122, 113, /* 648-655 */
105,  97,  89,  82,  76,  70,  66,  58, /* 656-663 */
 49,  47,  45,  44,  50,  50,  59,  75, /* 664-671 */
 91,  95,  94,  95,  96,  96,  96,  97, /* 672-679 */
 98,  98,  99, 100, 100, 102, 103, 104, /* 680-687 */
106, 109, 124, 140, 156, 171, 186, 200, /* 688-695 */
212, 225, 227, 221, 215, 220, 228, 234, /* 696-703 */
227, 217, 207, 199, 190, 187, 198, 215, /* 704-711 */
230, 235, 231, 229, 225, 222, 219, 217, /* 712-719 */
214, 211, 209, 206, 204, 201, 199, 197, /* 720-727 */
195, 180, 163, 141, 136, 137, 133, 122, /* 728-735 */
112,  97,  86,  73,  70,  75,  79,  73, /* 736-743 */
 63,  54,  46,  39,  32,  26,  20,  15, /* 744-751 */
 11,   8,  13,  25,  38,  40,  37,  37, /* 752-759 */
 49,  63,  73,  70,  68,  65,  63,  60, /* 760-767 */
 66,  80,  92, 104, 116, 126, 124, 113, /* 768-775 */
 95,  94,  95,  93,  81,  71,  63,  55, /* 776-783 */
 49,  44,  40,  38,  49,  62,  76,  89, /* 784-791 */
103, 117, 129, 142, 146, 141, 134, 124, /* 792-799 */
122, 119, 129, 147, 157, 165, 174, 182, /* 800-807 */
189, 196, 203, 209, 214, 219, 222, 226, /* 808-815 */
228, 230, 229, 214, 199, 183, 168, 153, /* 816-823 */
147, 149, 151, 154, 156, 167, 182, 193, /* 824-831 */
200, 191, 182, 171, 160, 148, 146, 152, /* 832-839 */
156, 160, 164, 168, 171, 175, 177, 179, /* 840-847 */
182, 184, 184, 185, 177, 159, 143, 127, /* 848-855 */
112,  98,  96,  99, 101, 104, 107, 110, /* 856-863 */
113, 118, 107,  90,  79,  66,  57,  52, /* 864-871 */
 42,  33,  27,  34,  43,  47,  41,  35, /* 872-879 */
 37,  49,  60,  70,  67,  64,  58,  61, /* 880-887 */
 62,  52,  42,  39,  50,  60,  71,  81, /* 888-895 */
 91,  90,  82,  77,  71,  65,  60,  56, /* 896-903 */
 52,  49,  47,  45,  52,  67,  81,  97, /* 904-911 */
112, 126, 141, 155, 166, 164, 160, 156, /* 912-919 */
153, 149, 144, 141, 137, 144, 156, 167, /* 920-927 */
166, 162, 159, 157, 154, 155, 168, 181, /* 928-935 */
192, 208, 232, 247, 254, 255, 255, 255, /* 936-943 */
255, 252, 248, 243, 238, 228, 226, 233, /* 944-951 */
238, 241, 242, 240, 238, 236, 232, 229, /* 952-959 */
226, 223, 212, 197, 192, 194, 197, 189, /* 960-967 */
175, 164, 165, 169, 170, 159, 147, 141, /* 968-975 */
145, 150, 147, 136, 125, 125, 131, 136, /* 976-983 */
131, 121, 115, 120, 125, 130, 134, 139, /* 984-991 */
133, 122, 117, 102,  83,  67,  65,  67, /* 992-999 */
 70,  73,  77,  83,  87,  93,  91,  80, /* 1000-1007 */
 69,  70,  77,  82,  75,  65,  59,  65, /* 1008-1015 */
 72,  80,  88,  95, 103, 109, 117, 114, /* 1016-1023 */
104,  95,  85,  77,  70,  76,  85,  88, /* 1024-1031 */
 80,  73,  67,  61,  55,  60,  71,  81, /* 1032-1039 */
 92, 103, 112, 108, 102, 102, 124, 144, /* 1040-1047 */
161, 176, 189, 201, 211, 219, 214, 203, /* 1048-1055 */
194, 183, 172, 161, 150, 139, 136, 142, /* 1056-1063 */
147, 143, 132, 124, 127, 134, 141, 147, /* 1064-1071 */
153, 155, 145, 136, 135, 143, 149, 155, /* 1072-1079 */
159, 163, 154, 141, 129, 118, 106,  99, /* 1080-1087 */
104, 109, 114, 120, 125, 131, 136, 141, /* 1088-1095 */
146, 151, 155, 159, 157, 141, 115,  93, /* 1096-1103 */
 73,  55,  39,  25,  13,   6,   2,   0, /* 1104-1111 */
  0,   0,   0,   0,   2,   9,  17,  17, /* 1112-1119 */
 18,  28,  46,  63,  68,  68,  70,  71, /* 1120-1127 */
 72,  78,  94, 110, 120, 119, 120, 120, /* 1128-1135 */
120, 120, 119, 119, 121, 135, 150, 164, /* 1136-1143 */
178, 192, 205, 217, 229, 239, 245, 249, /* 1144-1151 */
253, 255, 255, 255, 253, 251, 249, 247, /* 1152-1159 */
245, 243, 241, 239, 237, 233, 230, 227, /* 1160-1167 */
224, 221, 219, 216, 213, 210, 203, 202, /* 1168-1175 */
201, 192, 174, 159, 144, 129, 117, 118, /* 1176-1183 */
121, 124, 128, 131, 135, 138, 142, 136, /* 1184-1191 */
123, 111,  99,  87,  78,  81,  86,  87, /* 1192-1199 */
 78,  67,  65,  72,  79,  77,  69,  63, /* 1200-1207 */
 66,  62,  56,  41,  26,  14,   7,   3, /* 1208-1215 */
  1,   7,  16,  27,  39,  51,  64,  76, /* 1216-1223 */
 89, 100, 112, 122, 132, 142, 145, 135, /* 1224-1231 */
128, 119, 111, 103,  95,  88,  81,  75, /* 1232-1239 */
 68,  67,  78,  90,  95,  91,  87,  92, /* 1240-1247 */
104, 115, 126, 136, 145, 143, 137, 136, /* 1248-1255 */
145, 154, 157, 152, 148, 143, 140, 146, /* 1256-1263 */
160, 176, 188, 200, 210, 219, 227, 233, /* 1264-1271 */
239, 242, 244, 243, 241, 239, 237, 234, /* 1272-1279 */
230, 228, 221, 207, 204, 202, 199, 196, /* 1280-1287 */
194, 183, 165, 149, 144, 143, 142, 141, /* 1288-1295 */
140, 140, 140, 140, 140, 140, 140, 139, /* 1296-1303 */
139, 138, 137, 136, 135, 134, 132, 131, /* 1304-1311 */
129, 127, 126, 123, 122, 106,  72,  45, /* 1312-1319 */
 31,  25,  18,   5,   0,   0,   0,   0, /* 1320-1327 */
  0,   0,   2,   7,  13,  19,  28,  36, /* 1328-1335 */
 44,  52,  60,  68,  75,  82,  84,  74, /* 1336-1343 */
 65,  57,  49,  41,  44,  52,  60,  57, /* 1344-1351 */
 52,  52,  62,  72,  76,  70,  65,  68, /* 1352-1359 */
 79,  89,  89,  84,  81,  78,  75,  75, /* 1360-1367 */
 87, 100, 106, 112, 123, 129, 134, 138, /* 1368-1375 */
151, 167, 182, 196, 208, 217, 215, 210, /* 1376-1383 */
210, 220, 228, 236, 242, 246, 249, 251, /* 1384-1391 */
253, 248, 242, 232, 220, 208, 202, 205, /* 1392-1399 */
208, 211, 214, 217, 209, 197, 187, 188, /* 1400-1407 */
191, 194, 197, 200, 202, 205, 207, 209, /* 1408-1415 */
210, 211, 201, 186, 173, 158, 145, 130, /* 1416-1423 */
104,  80,  64,  62,  61,  62,  65,  69, /* 1424-1431 */
 75,  81,  87,  94, 102, 106,  99,  91, /* 1432-1439 */
 84,  77,  72,  67,  64,  60,  66,  77, /* 1440-1447 */
 85,  83,  78,  77,  87,  98, 103,  99, /* 1448-1455 */
 95,  99, 111, 121, 132, 142, 151, 148, /* 1456-1463 */
142, 139, 147, 156, 160, 152, 146, 140, /* 1464-1471 */
134, 128, 122, 117, 113, 120, 130, 137, /* 1472-1479 */
134, 129, 130, 142, 151, 161, 171, 180, /* 1480-1487 */
189, 196, 203, 198, 189, 183, 189, 194, /* 1488-1495 */
199, 203, 207, 211, 214, 217, 209, 196, /* 1496-1503 */
185, 184, 187, 185, 173, 160, 152, 155, /* 1504-1511 */
157, 153, 140, 129, 128, 132, 135, 127, /* 1512-1519 */
116, 106,  97,  88,  84,  91,  98, 104, /* 1520-1527 */
111, 118, 115, 106,  99,  92,  86,  83, /* 1528-1535 */
 92, 101, 105,  97,  90,  91,  98, 105, /* 1536-1543 */
113, 120, 126, 133, 140, 143, 135, 126, /* 1544-1551 */
121, 127, 132, 130, 119, 110, 111, 117, /* 1552-1559 */
121, 126, 132, 136, 140, 146, 145, 134, /* 1560-1567 */
123, 119, 123, 127, 121, 110, 101, 104, /* 1568-1575 */
109, 111, 103,  93,  89,  95, 101, 100, /* 1576-1583 */
 91,  84,  85,  93, 100, 107, 114, 118, /* 1584-1591 */
111, 103,  96,  88,  81,  75,  68,  63, /* 1592-1599 */
 58,  53,  49,  46,  44,  44,  56,  69, /* 1600-1607 */
 82,  94, 107, 113, 110, 108, 106, 104, /* 1608-1615 */
102, 111, 123, 132, 129, 125, 126, 137, /* 1616-1623 */
147, 150, 146, 143, 149, 161, 169, 177, /* 1624-1631 */
184, 189, 181, 172, 164, 156, 147, 145, /* 1632-1639 */
152, 158, 164, 169, 175, 181, 186, 190, /* 1640-1647 */
194, 199, 198, 185, 174, 162, 151, 139, /* 1648-1655 */
137, 141, 144, 148, 151, 155, 158, 162, /* 1656-1663 */
165, 168, 171, 174, 175, 177, 169, 155, /* 1664-1671 */
142, 128, 115, 103,  91,  79,  73,  78, /* 1672-1679 */
 83,  83,  73,  66,  59,  53,  48,  43, /* 1680-1687 */
 38,  36,  46,  58,  69,  80,  92,  96, /* 1688-1695 */
 93,  89,  95, 106, 116, 114, 109, 107, /* 1696-1703 */
115, 125, 130, 125, 119, 120, 130, 138, /* 1704-1711 */
146, 153, 160, 167, 174, 178, 171, 163, /* 1712-1719 */
159, 165, 169, 173, 176, 178, 180, 182, /* 1720-1727 */
184, 185, 187, 186, 172, 158, 144, 131, /* 1728-1735 */
117, 111, 114, 116, 119, 122, 125, 117, /* 1736-1743 */
106,  98, 101, 106, 110, 115, 120, 119, /* 1744-1751 */
108,  99,  89,  81,  72,  65,  59,  54, /* 1752-1759 */
 62,  71,  80,  89,  99, 102,  96,  92, /* 1760-1767 */
 87,  83,  79,  75,  71,  69,  80,  91, /* 1768-1775 */
102, 113, 124, 135, 146, 155, 164, 173, /* 1776-1783 */
181, 188, 194, 199, 190, 180, 170, 160, /* 1784-1791 */
149, 145, 151, 155, 160, 164, 169, 173, /* 1792-1799 */
178, 180, 171, 159, 149, 138, 127, 123, /* 1800-1807 */
128, 133, 139, 145, 152, 147, 137, 129, /* 1808-1815 */
132, 136, 141, 144, 149, 147, 136, 126, /* 1816-1823 */
116, 107,  98,  89,  82,  76,  82,  90, /* 1824-1831 */
 95,  89,  84,  80,  76,  72,  68,  66, /* 1832-1839 */
 63,  62,  60,  61,  73,  87,  97,  97, /* 1840-1847 */
 96, 103, 117, 131, 136, 134, 133, 142, /* 1848-1855 */
155, 164, 163, 159, 156, 152, 148, 150, /* 1856-1863 */
161, 171, 180, 189, 198, 206, 213, 220, /* 1864-1871 */
226, 232, 233, 223, 212, 207, 210, 213, /* 1872-1879 */
207, 194, 183, 171, 160, 149, 139, 129, /* 1880-1887 */
120, 112, 104, 102, 110, 118, 119, 112, /* 1888-1895 */
107, 102,  97,  93,  89,  85,  87, 100, /* 1896-1903 */
113, 119, 116, 112, 108, 105, 102, 109, /* 1904-1911 */
119, 129, 126, 122, 119, 116, 112, 114, /* 1912-1919 */
125, 136, 138, 133, 130, 126, 122, 120, /* 1920-1927 */
129, 139, 148, 158, 167, 175, 183, 191, /* 1928-1935 */
197, 203, 208, 213, 216, 219, 209, 196, /* 1936-1943 */
187, 188, 190, 186, 172, 158, 154, 156, /* 1944-1951 */
157, 148, 135, 125, 126, 129, 129, 118, /* 1952-1959 */
107, 102, 105, 109, 105,  94,  86,  77, /* 1960-1967 */
 69,  62,  55,  49,  46,  53,  62,  65, /* 1968-1975 */
 61,  57,  60,  71,  80,  89,  98, 106, /* 1976-1983 */
103,  98,  96, 104, 112, 115, 108, 103, /* 1984-1991 */
 98,  93,  89,  86,  83,  81,  88,  97, /* 1992-1999 */
102,  98,  93,  89,  86,  82,  86,  97, /* 2000-2007 */
106, 107, 103, 100,  98,  95,  95, 105, /* 2008-2015 */
116, 122, 119, 116, 120, 131, 140, 141, /* 2016-2023 */
136, 134, 141, 150, 158, 166, 173, 180, /* 2024-2031 */
187, 194, 192, 184, 176, 177, 182, 184, /* 2032-2039 */
177, 167, 160, 164, 167, 171, 173, 177, /* 2040-2047 */
173, 163, 153, 152, 156, 157, 149, 138, /* 2048-2055 */
131, 135, 138, 142, 145, 148, 152, 155, /* 2056-2063 */
158, 151, 140, 130, 120, 110, 103, 106, /* 2064-2071 */
110, 110, 101,  93,  92,  97, 103, 100, /* 2072-2079 */
 91,  85,  79,  73,  67,  63,  59,  62, /* 2080-2087 */
 72,  83,  86,  80,  78,  74,  71,  68, /* 2088-2095 */
 66,  63,  63,  74,  86,  97, 108, 119, /* 2096-2103 */
129, 139, 149, 149, 144, 140, 146, 154, /* 2104-2111 */
161, 167, 173, 179, 184, 189, 187, 176, /* 2112-2119 */
167, 158, 148, 140, 142, 147, 151, 156, /* 2120-2127 */
160, 164, 168, 172, 175, 178, 181, 174, /* 2128-2135 */
163, 153, 153, 156, 155, 145, 133, 127, /* 2136-2143 */
130, 133, 130, 119, 110, 101,  93,  86, /* 2144-2151 */
 89,  95, 101, 107, 114, 120, 126, 132, /* 2152-2159 */
131, 123, 116, 108, 101,  94,  87,  81, /* 2160-2167 */
 77,  85,  92, 100, 108, 116, 123, 130, /* 2168-2175 */
138, 136, 131, 127, 132, 139, 144, 149, /* 2176-2183 */
153, 153, 144, 134, 131, 136, 140, 135, /* 2184-2191 */
125, 117, 109, 101,  93,  87,  80,  75, /* 2192-2199 */
 70,  66,  62,  60,  58,  64,  77,  88, /* 2200-2207 */
 99, 111, 122, 133, 143, 149, 145, 141, /* 2208-2215 */
143, 153, 161, 160, 154, 149, 154, 162, /* 2216-2223 */
166, 160, 154, 148, 142, 136, 130, 125, /* 2224-2231 */
120, 115, 111, 108, 105, 102, 100,  99, /* 2232-2239 */
 97,  97,  97,  97,  97,  98,  99, 100, /* 2240-2247 */
102, 104, 117, 131, 143, 145, 146, 151, /* 2248-2255 */
163, 176, 182, 179, 178, 184, 195, 203, /* 2256-2263 */
212, 220, 226, 233, 238, 241, 241, 239, /* 2264-2271 */
237, 234, 231, 228, 225, 222, 219, 216, /* 2272-2279 */
214, 211, 208, 206, 204, 200, 191, 187, /* 2280-2287 */
182, 169, 152, 136, 131, 130, 126, 113, /* 2288-2295 */
 99,  86,  74,  63,  53,  43,  35,  35, /* 2296-2303 */
 42,  48,  54,  61,  69,  77,  84,  91, /* 2304-2311 */
 98, 105, 110, 116, 121, 126, 130, 133, /* 2312-2319 */
126, 115, 105,  95,  85,  79,  83,  87, /* 2320-2327 */
 86,  76,  69,  62,  55,  49,  43,  38, /* 2328-2335 */
 36,  44,  54,  63,  73,  83,  87,  83, /* 2336-2343 */
 80,  77,  74,  72,  69,  67,  66,  76, /* 2344-2351 */
 88,  95,  93,  91,  95, 107, 118, 128, /* 2352-2359 */
138, 149, 160, 170, 178, 186, 192, 196, /* 2360-2367 */
200, 204, 206, 208, 210, 203, 190, 178, /* 2368-2375 */
175, 177, 177, 177, 178, 175, 162, 150, /* 2376-2383 */
137, 126, 114, 112, 115, 118, 111, 101, /* 2384-2391 */
 93,  86,  78,  75,  82,  89,  91,  85, /* 2392-2399 */
 80,  84,  94, 102, 111, 120, 127, 123, /* 2400-2407 */
117, 116, 124, 132, 133, 127, 122, 116, /* 2408-2415 */
111, 106, 111, 120, 127, 135, 143, 147, /* 2416-2423 */
142, 136, 136, 143, 150, 149, 142, 136, /* 2424-2431 */
140, 147, 152, 146, 140, 134, 128, 121, /* 2432-2439 */
121, 129, 136, 136, 130, 125, 130, 139, /* 2440-2447 */
144, 140, 134, 132, 139, 147, 156, 164, /* 2448-2455 */
171, 178, 184, 188, 191, 195, 196, 186, /* 2456-2463 */
174, 166, 168, 170, 166, 154, 143, 140, /* 2464-2471 */
143, 145, 148, 150, 152, 142, 132, 122, /* 2472-2479 */
112, 103,  99, 104, 109, 107,  98,  91, /* 2480-2487 */
 85,  78,  73,  68,  64,  61,  58,  55, /* 2488-2495 */
 59,  70,  81,  93, 104, 115, 116, 113, /* 2496-2503 */
112, 121, 131, 138, 134, 130, 131, 141, /* 2504-2511 */
148, 156, 164, 171, 177, 183, 189, 194, /* 2512-2519 */
198, 201, 205, 207, 209, 210, 211, 211, /* 2520-2527 */
211, 210, 209, 207, 204, 190, 173, 161, /* 2528-2535 */
159, 157, 156, 154, 152, 151, 149, 148, /* 2536-2543 */
137, 123, 111,  99,  88,  75,  63,  52, /* 2544-2551 */
 41,  32,  23,  23,  30,  36,  34,  29, /* 2552-2559 */
 26,  34,  44,  53,  63,  72,  82,  91, /* 2560-2567 */
101, 102,  96,  91,  86,  81,  78,  84, /* 2568-2575 */
 93, 101, 109, 117, 120, 114, 109, 104, /* 2576-2583 */
 99,  95,  91,  87,  84,  92, 102, 112, /* 2584-2591 */
121, 131, 140, 149, 157, 165, 172, 179, /* 2592-2599 */
185, 191, 194, 187, 177, 168, 159, 149, /* 2600-2607 */
140, 132, 123, 123, 129, 134, 140, 146, /* 2608-2615 */
151, 145, 138, 131, 125, 119, 112, 107, /* 2616-2623 */
101, 103, 113, 121, 129, 137, 145, 153, /* 2624-2631 */
160, 167, 174, 179, 180, 173, 166, 159, /* 2632-2639 */
151, 144, 135, 126, 119, 122, 127, 132, /* 2640-2647 */
137, 144, 144, 136, 129, 122, 116, 109, /* 2648-2655 */
112, 119, 126, 132, 139, 146, 152, 158, /* 2656-2663 */
159, 151, 142, 142, 148, 152, 156, 160, /* 2664-2671 */
164, 156, 146, 139, 143, 147, 147, 137, /* 2672-2679 */
128, 126, 130, 133, 137, 141, 144, 137, /* 2680-2687 */
127, 121, 125, 129, 133, 136, 141, 138, /* 2688-2695 */
128, 120, 111, 103,  96,  99, 105, 110, /* 2696-2703 */
115, 121, 122, 114, 108, 101,  95,  89, /* 2704-2711 */
 83,  78,  74,  69,  66,  63,  61,  58, /* 2712-2719 */
 61,  73,  84,  95, 106, 117, 119, 116, /* 2720-2727 */
115, 115, 114, 115, 126, 135, 143, 151, /* 2728-2735 */
159, 160, 153, 149, 143, 138, 133, 138, /* 2736-2743 */
146, 152, 159, 165, 171, 176, 182, 187, /* 2744-2751 */
190, 194, 189, 179, 170, 160, 151, 143, /* 2752-2759 */
146, 150, 153, 156, 160, 157, 147, 138, /* 2760-2767 */
130, 123, 116, 118, 124, 127, 120, 114, /* 2768-2775 */
107, 102,  96,  97, 104, 112, 110, 105, /* 2776-2783 */
102, 108, 116, 123, 131, 138, 141, 135, /* 2784-2791 */
130, 130, 137, 143, 149, 153, 158, 153, /* 2792-2799 */
144, 139, 143, 147, 151, 155, 159, 156, /* 2800-2807 */
146, 138, 129, 120, 112, 105,  97,  90, /* 2808-2815 */
 84,  78,  73,  68,  65,  63,  62,  61, /* 2816-2823 */
 69,  81,  91,  90,  87,  88,  98, 108, /* 2824-2831 */
114, 111, 109, 107, 105, 102, 108, 119, /* 2832-2839 */
128, 137, 146, 153, 150, 145, 141, 137, /* 2840-2847 */
133, 128, 125, 120, 125, 133, 141, 139, /* 2848-2855 */
134, 132, 140, 148, 153, 149, 145, 146, /* 2856-2863 */
154, 162, 161, 155, 150, 145, 140, 135, /* 2864-2871 */
130, 125, 124, 133, 140, 148, 156, 163, /* 2872-2879 */
170, 176, 182, 188, 193, 195, 187, 178, /* 2880-2887 */
169, 161, 151, 148, 152, 155, 150, 141, /* 2888-2895 */
133, 135, 140, 143, 147, 151, 155, 158, /* 2896-2903 */
162, 159, 148, 139, 129, 120, 110, 102, /* 2904-2911 */
 94,  89,  83,  78,  73,  67,  61,  56, /* 2912-2919 */
 52,  49,  53,  64,  73,  83,  93, 101, /* 2920-2927 */
 99,  96,  94,  91,  89,  86,  84,  82, /* 2928-2935 */
 80,  78,  77,  86,  97, 108, 119, 129, /* 2936-2943 */
139, 148, 157, 165, 172, 179, 177, 170, /* 2944-2951 */
164, 167, 173, 175, 168, 159, 154, 159, /* 2952-2959 */
162, 165, 169, 172, 175, 177, 180, 182, /* 2960-2967 */
183, 183, 172, 160, 149, 138, 126, 121, /* 2968-2975 */
124, 125, 128, 131, 133, 136, 138, 140, /* 2976-2983 */
142, 145, 144, 132, 122, 111, 101,  91, /* 2984-2991 */
 89,  93,  96, 100, 104, 108, 111, 115, /* 2992-2999 */
119, 122, 125, 123, 113, 105,  97,  89, /* 3000-3007 */
 82,  74,  65,  57,  50,  43,  40,  48, /* 3008-3015 */
 55,  63,  70,  79,  80,  75,  72,  78, /* 3016-3023 */
 88,  96, 104, 112, 120, 127, 135, 136, /* 3024-3031 */
129, 123, 124, 131, 135, 131, 123, 118, /* 3032-3039 */
123, 128, 133, 139, 145, 151, 156, 160, /* 3040-3047 */
165, 169, 172, 165, 156, 146, 137, 128, /* 3048-3055 */
120, 112, 104,  97,  91,  85,  80,  76, /* 3056-3063 */
 73,  79,  89,  98,  97,  94,  96, 107, /* 3064-3071 */
117, 122, 120, 118, 124, 134, 144, 144, /* 3072-3079 */
140, 137, 135, 132, 129, 126, 124, 122, /* 3080-3087 */
120, 119, 118, 116, 116, 115, 115, 115, /* 3088-3095 */
117, 120, 122, 124, 126, 132, 144, 156, /* 3096-3103 */
161, 160, 159, 159, 158, 159, 169, 180, /* 3104-3111 */
187, 185, 183, 181, 178, 176, 173, 170, /* 3112-3119 */
168, 165, 163, 161, 159, 156, 157, 168, /* 3120-3127 */
177, 187, 196, 205, 213, 220, 227, 234, /* 3128-3135 */
238, 237, 234, 227, 218, 209, 199, 195, /* 3136-3143 */
198, 200, 202, 204, 205, 206, 204, 202, /* 3144-3151 */
199, 197, 195, 193, 191, 189, 187, 185, /* 3152-3159 */
183, 181, 179, 178, 168, 153, 148, 146, /* 3160-3167 */
140, 125, 110, 101, 101,  99,  99,  99, /* 3168-3175 */
 99,  90,  78,  67,  56,  46,  37,  28, /* 3176-3183 */
 20,  17,  23,  29,  29,  25,  22,  28, /* 3184-3191 */
 38,  45,  41,  36,  32,  28,  25,  21, /* 3192-3199 */
 19,  16,  22,  33,  44,  54,  65,  75, /* 3200-3207 */
 74,  72,  71,  69,  67,  69,  81,  90, /* 3208-3215 */
100, 110, 119, 128, 136, 143, 140, 134, /* 3216-3223 */
129, 124, 118, 117, 126, 133, 139, 146, /* 3224-3231 */
152, 159, 164, 169, 163, 155, 147, 140, /* 3232-3239 */
133, 130, 135, 141, 139, 132, 125, 128, /* 3240-3247 */
135, 139, 134, 128, 122, 116, 111, 106, /* 3248-3255 */
102,  97, 100, 109, 117, 126, 134, 143, /* 3256-3263 */
151, 158, 163, 158, 152, 150, 157, 162, /* 3264-3271 */
168, 172, 177, 172, 163, 156, 158, 163, /* 3272-3279 */
165, 158, 151, 143, 136, 127, 125, 129, /* 3280-3287 */
133, 128, 120, 113, 106, 100,  96, 103, /* 3288-3295 */
110, 117, 124, 131, 132, 125, 120, 115, /* 3296-3303 */
110, 105, 101,  97,  93,  89,  86,  88, /* 3304-3311 */
 98, 108, 111, 108, 107, 105, 103, 102, /* 3312-3319 */
102, 101, 100, 100, 100, 104, 117, 129, /* 3320-3327 */
134, 133, 133, 132, 132, 132, 142, 153, /* 3328-3335 */
161, 160, 158, 156, 155, 151, 156, 166, /* 3336-3343 */
175, 175, 171, 168, 165, 161, 160, 168, /* 3344-3351 */
176, 180, 175, 171, 166, 162, 157, 161, /* 3352-3359 */
169, 176, 183, 190, 194, 188, 181, 175, /* 3360-3367 */
168, 160, 160, 166, 171, 169, 163, 158, /* 3368-3375 */
162, 167, 171, 174, 177, 176, 166, 156, /* 3376-3383 */
153, 157, 159, 153, 143, 134, 125, 116, /* 3384-3391 */
110, 113, 118, 117, 109, 102,  96,  89, /* 3392-3399 */
 83,  78,  73,  68,  64,  61,  59,  68, /* 3400-3407 */
 76,  84,  92, 102, 105, 102, 100, 105, /* 3408-3415 */
113, 120, 118, 114, 110, 106, 103,  99, /* 3416-3423 */
 96,  93,  95, 104, 112, 120, 127, 135, /* 3424-3431 */
142, 149, 153, 148, 143, 138, 132, 126, /* 3432-3439 */
121, 116, 110, 113, 120, 125, 132, 137, /* 3440-3447 */
143, 149, 154, 159, 163, 167, 165, 156, /* 3448-3455 */
149, 140, 132, 125, 126, 129, 132, 136, /* 3456-3463 */
141, 146, 150, 153, 156, 157, 158, 151, /* 3464-3471 */
139, 129, 119, 109, 101, 103, 105, 104, /* 3472-3479 */
 96,  88,  86,  91,  95,  99, 103, 107, /* 3480-3487 */
102,  95,  89,  83,  77,  75,  81,  87, /* 3488-3495 */
 88,  83,  79,  74,  71,  68,  74,  83, /* 3496-3503 */
 90,  88,  85,  86,  95, 104, 112, 120, /* 3504-3511 */
128, 136, 142, 148, 146, 140, 135, 130, /* 3512-3519 */
124, 119, 114, 109, 110, 117, 124, 124, /* 3520-3527 */
119, 116, 122, 129, 134, 131, 127, 126, /* 3528-3535 */
134, 141, 148, 153, 160, 159, 153, 148, /* 3536-3543 */
142, 136, 133, 138, 144, 147, 141, 136, /* 3544-3551 */
131, 126, 121, 123, 132, 140, 147, 155, /* 3552-3559 */
160, 155, 149, 143, 137, 131, 125, 120, /* 3560-3567 */
115, 110, 106, 103, 108, 117, 124, 132, /* 3568-3575 */
140, 147, 154, 161, 162, 156, 152, 146, /* 3576-3583 */
141, 136, 139, 146, 151, 156, 161, 166, /* 3584-3591 */
170, 174, 173, 166, 159, 159, 163, 166, /* 3592-3599 */
160, 151, 145, 148, 151, 152, 144, 136, /* 3600-3607 */
129, 122, 115, 116, 121, 126, 131, 136, /* 3608-3615 */
141, 145, 150, 154, 157, 161, 159, 151, /* 3616-3623 */
142, 141, 144, 146, 148, 150, 152, 154, /* 3624-3631 */
156, 154, 144, 134, 125, 116, 106, 104, /* 3632-3639 */
108, 110, 113, 116, 119, 122, 125, 128, /* 3640-3647 */
133, 137, 136, 127, 118, 108,  99,  90, /* 3648-3655 */
 81,  73,  67,  70,  75,  77,  72,  67, /* 3656-3663 */
 62,  59,  55,  52,  50,  48,  55,  65, /* 3664-3671 */
 74,  73,  72,  72,  72,  71,  71,  71, /* 3672-3679 */
 72,  73,  74,  75,  85,  97, 109, 121, /* 3680-3687 */
133, 145, 155, 165, 174, 182, 190, 197, /* 3688-3695 */
203, 208, 213, 216, 219, 222, 224, 225, /* 3696-3703 */
225, 225, 225, 224, 222, 221, 218, 216, /* 3704-3711 */
213, 210, 206, 192, 178, 164, 149, 136, /* 3712-3719 */
124, 112, 101,  90,  81,  73,  74,  78, /* 3720-3727 */
 81,  77,  71,  66,  62,  58,  59,  67, /* 3728-3735 */
 75,  83,  91,  99,  99,  97,  95,  93, /* 3736-3743 */
 91,  90,  98, 105, 112, 118, 125, 131, /* 3744-3751 */
137, 143, 139, 133, 128, 122, 117, 111, /* 3752-3759 */
106, 101, 101, 108, 114, 115, 110, 107, /* 3760-3767 */
112, 120, 126, 123, 120, 116, 113, 110, /* 3768-3775 */
107, 104, 102, 107, 117, 126, 135, 143, /* 3776-3783 */
152, 160, 167, 174, 180, 186, 191, 196, /* 3784-3791 */
199, 203, 205, 207, 209, 209, 210, 210, /* 3792-3799 */
209, 209, 207, 206, 200, 185, 173, 159, /* 3800-3807 */
147, 135, 132, 132, 131, 121, 111, 102, /* 3808-3815 */
 93,  84,  81,  86,  90,  88,  82,  77, /* 3816-3823 */
 72,  67,  64,  70,  78,  83,  79,  77, /* 3824-3831 */
 80,  91, 100, 102,  98,  95,  91,  87, /* 3832-3839 */
 85,  92, 100, 105, 102,  99,  96,  94, /* 3840-3847 */
 92,  96, 105, 114, 122, 131, 139, 146, /* 3848-3855 */
153, 160, 166, 172, 173, 166, 160, 153, /* 3856-3863 */
146, 139, 133, 126, 122, 125, 131, 137, /* 3864-3871 */
143, 148, 154, 159, 164, 169, 173, 176, /* 3872-3879 */
171, 163, 155, 147, 139, 134, 137, 140, /* 3880-3887 */
144, 147, 151, 148, 140, 133, 133, 138, /* 3888-3895 */
140, 134, 126, 119, 113, 106, 104, 110, /* 3896-3903 */
114, 120, 125, 130, 136, 141, 144, 139, /* 3904-3911 */
132, 125, 119, 112, 106, 100,  94,  95, /* 3912-3919 */
101, 107, 105, 100,  98,  95,  93,  93, /* 3920-3927 */
101, 108, 115, 122, 128, 134, 140, 146, /* 3928-3935 */
151, 155, 159, 153, 145, 138, 131, 124, /* 3936-3943 */
120, 125, 129, 133, 137, 141, 137, 130, /* 3944-3951 */
123, 117, 110, 106, 111, 116, 121, 126, /* 3952-3959 */
132, 131, 125, 120, 123, 128, 133, 128, /* 3960-3967 */
122, 119, 124, 129, 131, 125, 119, 114, /* 3968-3975 */
109, 104, 100,  96,  92,  98, 106, 112, /* 3976-3983 */
109, 106, 107, 116, 123, 131, 139, 146, /* 3984-3991 */
145, 140, 136, 132, 127, 125, 131, 138, /* 3992-3999 */
141, 136, 131, 127, 123, 119, 123, 130, /* 4000-4007 */
137, 144, 150, 157, 162, 168, 169, 164, /* 4008-4015 */
159, 160, 165, 170, 165, 156, 148, 149, /* 4016-4023 */
152, 152, 145, 136, 132, 136, 139, 137, /* 4024-4031 */
129, 122, 115, 109, 103,  97,  92,  89, /* 4032-4039 */
 95, 102, 109, 116, 123, 124, 119, 115, /* 4040-4047 */
118, 125, 131, 137, 142, 148, 153, 158, /* 4048-4055 */
163, 167, 170, 172, 175, 177, 179, 179, /* 4056-4063 */
180, 181, 180, 178, 167, 154, 146, 146, /* 4064-4071 */
145, 145, 144, 144, 136, 124, 114, 103, /* 4072-4079 */
 93,  84,  75,  67,  63,  68,  72,  77, /* 4080-4087 */
 83,  88,  86,  80,  76,  71,  67,  63, /* 4088-4095 */
 59,  56,  54,  51,  49,  48,  47,  47, /* 4096-4103 */
 54,  66,  77,  88, 100, 112, 124, 134, /* 4104-4111 */
142, 149, 155, 160, 164, 168, 165, 157, /* 4112-4119 */
151, 144, 137, 132, 135, 138, 139, 132, /* 4120-4127 */
126, 121, 116, 110, 113, 119, 124, 129, /* 4128-4135 */
135, 140, 145, 151, 152, 147, 141, 141, /* 4136-4143 */
145, 149, 153, 158, 162, 165, 168, 171, /* 4144-4151 */
174, 176, 178, 179, 181, 177, 167, 158, /* 4152-4159 */
155, 157, 157, 149, 140, 133, 134, 136, /* 4160-4167 */
137, 139, 141, 142, 144, 146, 148, 149, /* 4168-4175 */
150, 151, 152, 153, 153, 153, 154, 153, /* 4176-4183 */
153, 148, 137, 127, 124, 124, 124, 116, /* 4184-4191 */
106,  99, 100, 101, 103, 105, 107, 111, /* 4192-4199 */
115, 119, 122, 124, 125, 118, 108, 101, /* 4200-4207 */
102, 103, 102,  94,  87,  79,  73,  67, /* 4208-4215 */
 68,  73,  78,  83,  88,  94,  99, 104, /* 4216-4223 */
110, 114, 119, 124, 128, 132, 130, 122, /* 4224-4231 */
116, 110, 104,  99, 103, 108, 110, 105, /* 4232-4239 */
101,  97,  93,  90,  87,  84,  82,  89, /* 4240-4247 */
 97, 104, 103, 102, 101, 100, 100, 103, /* 4248-4255 */
113, 122, 125, 124, 124, 131, 140, 148, /* 4256-4263 */
156, 163, 171, 177, 183, 189, 195, 199, /* 4264-4271 */
203, 206, 208, 203, 195, 188, 189, 191, /* 4272-4279 */
192, 192, 194, 190, 181, 172, 168, 170, /* 4280-4287 */
170, 163, 153, 146, 139, 133, 129, 132, /* 4288-4295 */
135, 134, 126, 119, 113, 107, 101,  96, /* 4296-4303 */
 91,  87,  83,  81,  78,  76,  75,  74, /* 4304-4311 */
 73,  73,  74,  75,  76,  85,  96, 106, /* 4312-4319 */
107, 108, 112, 122, 132, 142, 151, 160, /* 4320-4327 */
162, 159, 158, 156, 154, 152, 158, 165, /* 4328-4335 */
169, 165, 162, 158, 154, 151, 147, 144, /* 4336-4343 */
141, 145, 152, 157, 155, 151, 148, 145, /* 4344-4351 */
141, 142, 150, 156, 162, 168, 173, 178, /* 4352-4359 */
183, 186, 181, 175, 171, 174, 176, 179, /* 4360-4367 */
181, 183, 179, 170, 162, 153, 145, 138, /* 4368-4375 */
139, 142, 143, 145, 147, 149, 151, 154, /* 4376-4383 */
157, 159, 161, 154, 143, 133, 123, 113, /* 4384-4391 */
105, 106, 107, 108, 109, 111, 107,  98, /* 4392-4399 */
 91,  91,  95,  97,  99, 102, 103,  95, /* 4400-4407 */
 89,  82,  76,  69,  69,  75,  78,  83, /* 4408-4415 */
 88,  92,  96, 101, 103,  97,  92,  87, /* 4416-4423 */
 82,  77,  78,  84,  88,  94,  99, 103, /* 4424-4431 */
 99,  94,  92,  97, 102, 108, 112, 117, /* 4432-4439 */
122, 126, 130, 126, 119, 113, 107, 101, /* 4440-4447 */
 98, 102, 106, 107, 101,  97,  98, 103, /* 4448-4455 */
108, 106, 102,  98, 103, 109, 115, 120, /* 4456-4463 */
127, 128, 123, 118, 119, 125, 129, 126, /* 4464-4471 */
121, 117, 120, 127, 131, 127, 123, 122, /* 4472-4479 */
128, 132, 136, 139, 143, 146, 149, 151, /* 4480-4487 */
145, 138, 133, 136, 138, 141, 143, 146, /* 4488-4495 */
143, 136, 129, 129, 132, 134, 128, 121, /* 4496-4503 */
115, 109, 103, 101, 106, 112, 111, 106, /* 4504-4511 */
102,  98,  95,  93,  91,  89,  89,  97, /* 4512-4519 */
105, 110, 108, 108, 107, 106, 105, 105, /* 4520-4527 */
104, 105, 113, 123, 132, 141, 150, 158, /* 4528-4535 */
166, 174, 175, 172, 168, 164, 161, 157, /* 4536-4543 */
153, 149, 147, 153, 159, 161, 157, 153, /* 4544-4551 */
150, 146, 143, 140, 137, 134, 132, 130, /* 4552-4559 */
128, 126, 125, 123, 122, 122, 121, 123, /* 4560-4567 */
125, 133, 144, 152, 152, 150, 150, 158, /* 4568-4575 */
166, 169, 166, 163, 165, 172, 178, 177, /* 4576-4583 */
172, 169, 173, 178, 181, 176, 170, 168, /* 4584-4591 */
173, 176, 180, 183, 186, 182, 174, 168, /* 4592-4599 */
169, 172, 172, 164, 156, 152, 155, 157, /* 4600-4607 */
159, 162, 163, 165, 166, 167, 160, 150, /* 4608-4615 */
142, 134, 125, 117, 109, 102,  96,  89, /* 4616-4623 */
 84,  86,  91,  95,  92,  88,  84,  81, /* 4624-4631 */
 77,  78,  85,  92,  99, 106, 112, 118, /* 4632-4639 */
124, 129, 126, 122, 117, 112, 107, 106, /* 4640-4647 */
111, 116, 121, 125, 130, 134, 138, 140, /* 4648-4655 */
135, 128, 122, 117, 112, 110, 115, 119, /* 4656-4663 */
122, 125, 127, 130, 132, 133, 127, 119, /* 4664-4671 */
111, 104,  97,  90,  84,  79,  73,  69, /* 4672-4679 */
 65,  68,  75,  81,  79,  76,  74,  72, /* 4680-4687 */
 70,  72,  81,  89,  98, 105, 113, 114, /* 4688-4695 */
112, 110, 117, 125, 130, 128, 124, 124, /* 4696-4703 */
131, 137, 143, 148, 154, 152, 147, 143, /* 4704-4711 */
146, 150, 154, 158, 162, 162, 156, 149, /* 4712-4719 */
147, 151, 153, 156, 159, 161, 155, 147, /* 4720-4727 */
140, 133, 126, 119, 113, 107, 107, 112, /* 4728-4735 */
116, 115, 110, 106, 102,  99,  97, 103, /* 4736-4743 */
110, 114, 110, 108, 105, 103, 101, 101, /* 4744-4751 */
101, 101, 108, 116, 123, 130, 137, 143, /* 4752-4759 */
149, 155, 156, 151, 147, 142, 137, 133, /* 4760-4767 */
128, 124, 121, 127, 132, 138, 144, 149, /* 4768-4775 */
155, 160, 165, 162, 156, 151, 145, 139, /* 4776-4783 */
134, 129, 123, 121, 127, 132, 138, 143, /* 4784-4791 */
149, 147, 142, 138, 142, 147, 151, 155, /* 4792-4799 */
160, 161, 154, 148, 147, 151, 154, 151, /* 4800-4807 */
144, 138, 139, 143, 146, 149, 152, 152, /* 4808-4815 */
145, 138, 136, 139, 142, 144, 147, 149, /* 4816-4823 */
143, 135, 130, 132, 134, 135, 136, 138, /* 4824-4831 */
139, 139, 141, 136, 127, 120, 112, 105, /* 4832-4839 */
 99, 100, 104, 104, 100,  96,  95,  99, /* 4840-4847 */
102, 105, 108, 111, 113, 116, 118, 112, /* 4848-4855 */
106, 101,  95,  90,  89,  93,  97, 101, /* 4856-4863 */
105, 110, 114, 118, 121, 117, 111, 109, /* 4864-4871 */
113, 117, 117, 112, 107, 108, 113, 116, /* 4872-4879 */
114, 109, 107, 112, 117, 122, 127, 131, /* 4880-4887 */
136, 140, 144, 147, 151, 154, 157, 159, /* 4888-4895 */
161, 163, 164, 165, 166, 167, 163, 155, /* 4896-4903 */
146, 144, 145, 144, 138, 130, 123, 116, /* 4904-4911 */
109, 105, 108, 110, 114, 117, 120, 124, /* 4912-4919 */
127, 130, 127, 121, 116, 111, 106, 102, /* 4920-4927 */
 98,  93,  93,  99, 104, 109, 116, 123, /* 4928-4935 */
130, 136, 141, 145, 148, 151, 153, 156, /* 4936-4943 */
158, 159, 161, 156, 148, 141, 140, 142, /* 4944-4951 */
143, 144, 145, 144, 137, 130, 126, 128, /* 4952-4959 */
130, 127, 119, 113, 108, 102,  98, 101, /* 4960-4967 */
106, 109, 113, 118, 122, 126, 131, 131, /* 4968-4975 */
125, 121, 117, 113, 109, 105, 101, 101, /* 4976-4983 */
107, 112, 118, 123, 129, 130, 126, 124, /* 4984-4991 */
127, 133, 138, 143, 148, 152, 156, 160, /* 4992-4999 */
160, 154, 149, 144, 139, 134, 135, 139, /* 5000-5007 */
142, 146, 149, 153, 155, 159, 158, 151, /* 5008-5015 */
145, 140, 134, 128, 130, 133, 136, 139, /* 5016-5023 */
142, 145, 148, 152, 156, 160, 162, 159, /* 5024-5031 */
151, 143, 135, 127, 120, 113, 106, 102, /* 5032-5039 */
105, 108, 112, 115, 119, 118, 112, 108, /* 5040-5047 */
104, 100,  97, 101, 107, 109, 106, 103, /* 5048-5055 */
103, 109, 115, 115, 112, 109, 113, 119, /* 5056-5063 */
124, 130, 136, 141, 146, 151, 155, 158, /* 5064-5071 */
162, 164, 167, 169, 171, 172, 173, 174, /* 5072-5079 */
174, 172, 163, 154, 149, 149, 149, 149, /* 5080-5087 */
149, 149, 142, 133, 126, 126, 127, 127, /* 5088-5095 */
128, 129, 130, 131, 132, 133, 133, 134, /* 5096-5103 */
128, 119, 113, 113, 114, 115, 116, 118, /* 5104-5111 */
119, 120, 121, 122, 123, 124, 126, 128, /* 5112-5119 */
130, 132, 132, 131, 130, 129, 128, 126, /* 5120-5127 */
124, 123, 122, 121, 120, 119, 118, 116, /* 5128-5135 */
116, 115, 114, 113, 112, 111, 110, 110, /* 5136-5143 */
109, 108, 101,  92,  84,  83,  84,  85, /* 5144-5151 */
 85,  86,  88,  90,  91,  93,  96,  98, /* 5152-5159 */
 93,  86,  81,  83,  86,  87,  82,  77, /* 5160-5167 */
 75,  80,  84,  88,  93,  97, 102, 106, /* 5168-5175 */
110, 114, 119, 122, 126, 130, 133, 135, /* 5176-5183 */
138, 136, 129, 123, 124, 127, 129, 131, /* 5184-5191 */
134, 135, 129, 123, 120, 124, 127, 125, /* 5192-5199 */
119, 115, 110, 106, 102,  98,  95,  93, /* 5200-5207 */
 99, 106, 113, 121, 129, 132, 130, 128, /* 5208-5215 */
125, 122, 119, 124, 130, 136, 141, 147, /* 5216-5223 */
150, 146, 143, 140, 137, 134, 137, 144, /* 5224-5231 */
149, 154, 160, 165, 170, 175, 176, 171, /* 5232-5239 */
167, 162, 157, 153, 148, 144, 141, 144, /* 5240-5247 */
149, 155, 160, 165, 170, 174, 179, 178, /* 5248-5255 */
173, 168, 164, 159, 154, 149, 145, 141, /* 5256-5263 */
137, 133, 133, 138, 144, 145, 142, 139, /* 5264-5271 */
142, 149, 154, 159, 164, 169, 174, 178, /* 5272-5279 */
181, 184, 187, 189, 191, 192, 193, 194, /* 5280-5287 */
194, 194, 193, 191, 181, 171, 164, 164, /* 5288-5295 */
162, 161, 160, 158, 151, 141, 134, 127, /* 5296-5303 */
119, 114, 114, 114, 114, 114, 115, 116, /* 5304-5311 */
117, 117, 112, 105,  98,  91,  84,  80, /* 5312-5319 */
 82,  85,  86,  81,  76,  76,  81,  85, /* 5320-5327 */
 89,  94,  98, 102, 106, 111, 114, 118, /* 5328-5335 */
121, 123, 126, 128, 130, 132, 129, 121, /* 5336-5343 */
115, 116, 117, 119, 120, 122, 121, 114, /* 5344-5351 */
107, 104, 107, 109, 111, 113, 115, 110, /* 5352-5359 */
104,  98,  92,  87,  84,  89,  92,  96, /* 5360-5367 */
100, 105, 109, 113, 116, 113, 108, 103, /* 5368-5375 */
 99,  94,  93,  98, 103, 103,  99,  96, /* 5376-5383 */
 92,  90,  88,  92,  99, 105, 111, 116, /* 5384-5391 */
122, 128, 135, 141, 147, 152, 151, 145, /* 5392-5399 */
139, 133, 127, 121, 116, 111, 109, 113, /* 5400-5407 */
117, 117, 113, 109, 112, 118, 123, 128, /* 5408-5415 */
133, 137, 133, 130, 126, 123, 119, 116, /* 5416-5423 */
113, 110, 113, 119, 125, 131, 137, 143, /* 5424-5431 */
148, 154, 157, 153, 150, 146, 142, 138, /* 5432-5439 */
140, 145, 149, 153, 158, 161, 165, 169, /* 5440-5447 */
172, 175, 177, 175, 168, 162, 155, 149, /* 5448-5455 */
142, 136, 130, 124, 119, 114, 113, 117, /* 5456-5463 */
122, 123, 119, 116, 113, 111, 108, 113, /* 5464-5471 */
120, 126, 132, 137, 143, 148, 153, 158, /* 5472-5479 */
162, 166, 169, 171, 174, 176, 178, 181, /* 5480-5487 */
183, 184, 184, 182, 180, 178, 176, 173, /* 5488-5495 */
171, 168, 165, 155, 143, 133, 123, 112, /* 5496-5503 */
105, 105, 105, 101,  92,  86,  79,  73, /* 5504-5511 */
 67,  63,  58,  54,  51,  49,  47,  45, /* 5512-5519 */
 44,  48,  56,  65,  68,  69,  70,  71, /* 5520-5527 */
 72,  73,  74,  76,  79,  90,  99, 109, /* 5528-5535 */
118, 127, 130, 130, 130, 129, 128, 129, /* 5536-5543 */
136, 143, 149, 155, 160, 165, 170, 175, /* 5544-5551 */
174, 169, 165, 161, 156, 152, 147, 143, /* 5552-5559 */
141, 145, 149, 153, 156, 160, 159, 154, /* 5560-5567 */
150, 146, 142, 138, 134, 131, 127, 124, /* 5568-5575 */
121, 119, 118, 117, 117, 116, 115, 114, /* 5576-5583 */
112, 111, 109, 108, 109, 117, 123, 130, /* 5584-5591 */
137, 144, 150, 156, 162, 167, 171, 175, /* 5592-5599 */
179, 182, 184, 186, 188, 189, 190, 190, /* 5600-5607 */
190, 189, 188, 187, 186, 184, 182, 180, /* 5608-5615 */
176, 166, 157, 148, 138, 129, 121, 113, /* 5616-5623 */
105,  98,  92,  86,  81,  77,  73,  69, /* 5624-5631 */
 67,  64,  63,  61,  65,  73,  80,  87, /* 5632-5639 */
 94, 101, 108, 115, 119, 117, 115, 113, /* 5640-5647 */
111, 109, 111, 117, 122, 127, 132, 135, /* 5648-5655 */
133, 129, 126, 123, 119, 116, 113, 110, /* 5656-5663 */
112, 117, 121, 126, 131, 136, 142, 148, /* 5664-5671 */
151, 148, 143, 141, 143, 145, 143, 136, /* 5672-5679 */
131, 126, 120, 115, 111, 107, 102,  99, /* 5680-5687 */
 96,  96, 102, 107, 112, 117, 123, 122, /* 5688-5695 */
119, 117, 115, 112, 112, 117, 122, 127, /* 5696-5703 */
132, 137, 141, 145, 150, 154, 158, 161, /* 5704-5711 */
164, 166, 166, 160, 154, 148, 142, 136, /* 5712-5719 */
130, 124, 119, 120, 123, 126, 129, 132, /* 5720-5727 */
135, 138, 141, 141, 135, 130, 129, 133, /* 5728-5735 */
135, 137, 139, 142, 143, 145, 145, 139, /* 5736-5743 */
133, 130, 132, 133, 130, 123, 118, 112, /* 5744-5751 */
107, 102, 104, 107, 111, 114, 117, 120, /* 5752-5759 */
123, 127, 127, 123, 119, 115, 110, 105, /* 5760-5767 */
100,  95,  92,  95,  99, 100,  96,  93, /* 5768-5775 */
 94, 100, 104, 109, 114, 119, 123, 128, /* 5776-5783 */
132, 136, 139, 142, 145, 148, 150, 152, /* 5784-5791 */
154, 149, 142, 136, 130, 123, 119, 121, /* 5792-5799 */
123, 123, 118, 114, 109, 105, 101, 104, /* 5800-5807 */
108, 113, 117, 122, 125, 122, 119, 116, /* 5808-5815 */
113, 110, 108, 105, 103, 107, 113, 119, /* 5816-5823 */
125, 131, 134, 133, 130, 130, 136, 141, /* 5824-5831 */
142, 138, 136, 138, 143, 147, 152, 155, /* 5832-5839 */
160, 162, 166, 169, 171, 173, 175, 177, /* 5840-5847 */
178, 178, 179, 178, 171, 164, 159, 160, /* 5848-5855 */
161, 159, 150, 141, 137, 137, 136, 137, /* 5856-5863 */
137, 136, 129, 122, 116, 109, 103, 100, /* 5864-5871 */
103, 105, 104,  99,  95,  91,  87,  84, /* 5872-5879 */
 89,  94,  97,  95,  92,  93,  99, 105, /* 5880-5887 */
110, 116, 121, 121, 118, 117, 114, 112, /* 5888-5895 */
110, 108, 106, 104, 103, 102, 105, 112, /* 5896-5903 */
118, 125, 132, 138, 144, 150, 155, 160, /* 5904-5911 */
165, 169, 172, 175, 178, 180, 182, 178, /* 5912-5919 */
171, 165, 158, 151, 146, 148, 149, 148, /* 5920-5927 */
142, 136, 134, 137, 139, 142, 144, 146, /* 5928-5935 */
149, 150, 152, 154, 155, 154, 147, 140, /* 5936-5943 */
137, 140, 142, 144, 146, 147, 141, 133, /* 5944-5951 */
126, 126, 126, 127, 127, 127, 128, 128, /* 5952-5959 */
129, 129, 130, 130, 131, 131, 131, 131, /* 5960-5967 */
131, 129, 121, 113, 109, 110, 110, 111, /* 5968-5975 */
112, 112, 106,  99,  94,  96,  97,  99, /* 5976-5983 */
102, 105, 107, 110, 112, 109, 103,  98, /* 5984-5991 */
100, 103, 106, 108, 111, 114, 116, 119, /* 5992-5999 */
122, 124, 126, 123, 116, 111, 105, 100, /* 6000-6007 */
 95,  90,  86,  82,  79,  76,  77,  84, /* 6008-6015 */
 89,  95, 101, 108, 113, 119, 125, 130, /* 6016-6023 */
135, 140, 144, 148, 148, 143, 139, 134, /* 6024-6031 */
130, 125, 121, 116, 113, 111, 110, 108, /* 6032-6039 */
107, 105, 103, 102, 100, 103, 110, 116, /* 6040-6047 */
116, 115, 114, 114, 114, 113, 113, 113, /* 6048-6055 */
114, 114, 114, 120, 129, 136, 138, 138, /* 6056-6063 */
139, 147, 154, 159, 158, 157, 159, 166, /* 6064-6071 */
172, 177, 182, 187, 191, 196, 200, 203, /* 6072-6079 */
206, 208, 209, 210, 211, 211, 212, 206, /* 6080-6087 */
197, 189, 187, 186, 184, 176, 167, 161, /* 6088-6095 */
160, 160, 156, 148, 141, 134, 127, 120, /* 6096-6103 */
115, 109, 105, 107, 111, 112, 108, 104, /* 6104-6111 */
104, 109, 113, 117, 121, 125, 129, 133, /* 6112-6119 */
136, 139, 142, 145, 146, 148, 146, 139, /* 6120-6127 */
133, 127, 123, 117, 112, 107, 101,  95, /* 6128-6135 */
 90,  84,  80,  76,  76,  81,  85,  90, /* 6136-6143 */
 95, 100,  99,  96,  95, 100, 105, 108, /* 6144-6151 */
106, 103, 104, 109, 114, 119, 123, 127, /* 6152-6159 */
132, 136, 138, 134, 130, 125, 120, 116, /* 6160-6167 */
112, 109, 106, 107, 112, 116, 121, 126, /* 6168-6175 */
130, 134, 139, 140, 136, 132, 131, 135, /* 6176-6183 */
138, 136, 131, 127, 129, 133, 135, 130, /* 6184-6191 */
126, 122, 117, 113, 110, 106, 103, 105, /* 6192-6199 */
110, 115, 120, 125, 129, 127, 124, 121, /* 6200-6207 */
119, 116, 113, 111, 108, 111, 117, 122, /* 6208-6215 */
121, 118, 118, 123, 129, 133, 132, 132, /* 6216-6223 */
130, 128, 125, 126, 131, 135, 139, 143, /* 6224-6231 */
147, 151, 154, 157, 160, 163, 162, 156, /* 6232-6239 */
150, 144, 139, 134, 134, 137, 138, 133, /* 6240-6247 */
128, 125, 128, 131, 131, 126, 121, 117, /* 6248-6255 */
113, 109, 112, 116, 121, 126, 130, 132, /* 6256-6263 */
128, 125, 124, 128, 130, 133, 135, 138, /* 6264-6271 */
135, 130, 127, 129, 132, 132, 128, 124, /* 6272-6279 */
123, 126, 128, 127, 122, 119, 115, 112, /* 6280-6287 */
109, 106, 104, 101,  99,  98,  96,  95, /* 6288-6295 */
 94,  94,  94,  94,  99, 106, 113, 119, /* 6296-6303 */
126, 132, 138, 143, 148, 152, 157, 157, /* 6304-6311 */
154, 152, 151, 148, 146, 149, 151, 153, /* 6312-6319 */
154, 156, 154, 149, 144, 139, 134, 130, /* 6320-6327 */
130, 133, 135, 137, 139, 141, 143, 145, /* 6328-6335 */
147, 149, 151, 148, 142, 137, 137, 139, /* 6336-6343 */
139, 134, 129, 125, 127, 128, 127, 122, /* 6344-6351 */
119, 115, 112, 108, 105, 102,  99, 103, /* 6352-6359 */
107, 111, 116, 120, 122, 119, 117, 115, /* 6360-6367 */
113, 111, 113, 118, 122, 127, 131, 133, /* 6368-6375 */
131, 128, 128, 132, 136, 135, 131, 129, /* 6376-6383 */
131, 134, 137, 140, 143, 144, 141, 137, /* 6384-6391 */
135, 138, 140, 143, 145, 147, 144, 139, /* 6392-6399 */
134, 130, 125, 122, 125, 129, 130, 127, /* 6400-6407 */
124, 121, 116, 112, 108, 105, 101,  98, /* 6408-6415 */
 96,  94,  92,  91,  92,  98, 103, 109, /* 6416-6423 */
114, 120, 121, 119, 118, 117, 116, 115, /* 6424-6431 */
114, 113, 114, 120, 125, 130, 136, 140, /* 6432-6439 */
141, 138, 137, 135, 133, 132, 130, 128, /* 6440-6447 */
129, 134, 139, 144, 148, 152, 152, 149, /* 6448-6455 */
146, 144, 141, 140, 143, 147, 149, 145, /* 6456-6463 */
142, 140, 137, 134, 132, 129, 127, 125, /* 6464-6471 */
123, 122, 120, 119, 120, 126, 131, 133, /* 6472-6479 */
132, 131, 134, 140, 144, 149, 154, 156, /* 6480-6487 */
154, 151, 150, 154, 157, 156, 152, 148, /* 6488-6495 */
149, 154, 157, 154, 151, 147, 148, 149, /* 6496-6503 */
148, 142, 136, 135, 136, 137, 134, 128, /* 6504-6511 */
124, 119, 115, 112, 114, 117, 120, 122, /* 6512-6519 */
125, 127, 130, 132, 134, 136, 138, 140, /* 6520-6527 */
141, 142, 143, 143, 144, 144, 144, 141, /* 6528-6535 */
134, 128, 122, 116, 110, 110, 112, 113, /* 6536-6543 */
114, 116, 115, 109, 105, 100,  96,  92, /* 6544-6551 */
 93,  96,  99, 102, 105, 108, 104, 101, /* 6552-6559 */
 98,  95,  92,  93,  98, 101, 105, 109, /* 6560-6567 */
113, 111, 109, 106, 103, 101, 101, 105, /* 6568-6575 */
110, 111, 108, 106, 109, 114, 118, 117, /* 6576-6583 */
114, 114, 117, 122, 125, 124, 123, 122, /* 6584-6591 */
121, 119, 120, 124, 127, 125, 121, 120, /* 6592-6599 */
123, 128, 129, 126, 124, 125, 129, 133, /* 6600-6607 */
132, 129, 127, 130, 134, 137, 134, 132, /* 6608-6615 */
129, 127, 124, 125, 130, 134, 138, 141, /* 6616-6623 */
145, 149, 152, 155, 159, 162, 163, 158, /* 6624-6631 */
154, 153, 155, 157, 158, 160, 161, 156, /* 6632-6639 */
151, 146, 141, 136, 131, 127, 122, 121, /* 6640-6647 */
124, 127, 130, 133, 136, 133, 129, 127, /* 6648-6655 */
130, 133, 136, 139, 142, 141, 137, 133, /* 6656-6663 */
129, 125, 122, 124, 127, 129, 125, 122, /* 6664-6671 */
119, 116, 113, 111, 108, 106, 104, 102, /* 6672-6679 */
102, 103, 103, 104, 104, 103, 104, 109, /* 6680-6687 */
115, 117, 116, 115, 114, 114, 113, 113, /* 6688-6695 */
112, 112, 112, 112, 114, 121, 127, 134, /* 6696-6703 */
140, 146, 147, 146, 145, 143, 142, 141, /* 6704-6711 */
146, 151, 155, 159, 163, 163, 160, 158, /* 6712-6719 */
155, 153, 150, 147, 144, 141, 138, 136, /* 6720-6727 */
134, 132, 130, 131, 137, 141, 142, 139, /* 6728-6735 */
139, 142, 146, 150, 148, 145, 145, 150, /* 6736-6743 */
153, 157, 160, 163, 166, 168, 171, 172, /* 6744-6751 */
173, 174, 168, 162, 157, 151, 145, 142, /* 6752-6759 */
144, 144, 145, 145, 146, 141, 136, 130, /* 6760-6767 */
125, 119, 116, 118, 121, 121, 117, 115, /* 6768-6775 */
115, 118, 119, 115, 109, 105, 101,  97, /* 6776-6783 */
 94,  97, 100, 103, 107, 110, 113, 116, /* 6784-6791 */
118, 116, 112, 108, 105, 101, 107, 123, /* 6792-6799 */
133, 143, 150, 157, 162, 167, 170, 167, /* 6800-6807 */
162, 158, 152, 147, 142, 137, 131, 128, /* 6808-6815 */
130, 131, 132, 132, 133, 129, 123, 118, /* 6816-6823 */
113, 107, 104, 106, 108, 107, 102,  98, /* 6824-6831 */
 94,  90,  87,  84,  81,  78,  76,  74, /* 6832-6839 */
 74,  79,  84,  89,  94,  99, 100,  98, /* 6840-6847 */
 97, 101, 106, 110, 114, 118, 122, 126, /* 6848-6855 */
125, 129, 133, 136, 139, 142, 145, 146, /* 6856-6863 */
148, 146, 139, 133, 127, 123, 117, 112, /* 6864-6871 */
107, 101,  95,  90,  84,  80,  76,  76, /* 6872-6879 */
 81,  85,  90,  95, 100,  99,  96,  95, /* 6880-6887 */
100, 105, 108, 106, 103, 104, 109, 114, /* 6888-6895 */
119, 123, 127, 132, 136, 138, 134, 130, /* 6896-6903 */
125, 120, 116, 112, 109, 106, 107, 112, /* 6904-6911 */
116, 121, 126, 130, 134, 139, 140, 136, /* 6912-6919 */
132, 131, 135, 138, 136, 131, 127, 129, /* 6920-6927 */
133, 135, 130, 126, 122, 117, 113, 110, /* 6928-6935 */
106, 103, 105, 110, 115, 120, 125, 129, /* 6936-6943 */
127, 124, 121, 119, 116, 113, 111, 108, /* 6944-6951 */
111, 117, 122, 121, 118, 118, 123, 129, /* 6952-6959 */
133, 132, 132, 130, 128, 125, 126, 131, /* 6960-6967 */
135, 139, 143, 147, 151, 154, 157, 160, /* 6968-6975 */
163, 162, 156, 150, 144, 139, 134, 134, /* 6976-6983 */
137, 138, 133, 128, 125, 128, 131, 131, /* 6984-6991 */
126, 121, 117, 113, 109, 112, 116, 121, /* 6992-6999 */
126, 130, 132, 128, 125, 124, 128, 130, /* 7000-7007 */
133, 135, 138, 135, 130, 127, 129, 132, /* 7008-7015 */
132, 128, 124, 123, 126, 128, 127, 122, /* 7016-7023 */
119, 115, 112, 109, 106, 104, 101,  99, /* 7024-7031 */
 98,  96,  95,  94,  94,  94,  94,  99, /* 7032-7039 */
106, 113, 119, 126, 132, 138, 143, 148, /* 7040-7047 */
152, 157, 157, 154, 152, 151, 148, 146, /* 7048-7055 */
149, 151, 153, 154, 156, 154, 149, 144, /* 7056-7063 */
139, 134, 130, 130, 133, 135, 137, 139, /* 7064-7071 */
141, 143, 145, 147, 149, 151, 148, 142, /* 7072-7079 */
137, 137, 139, 139, 134, 129, 125, 127, /* 7080-7087 */
128, 127, 122, 119, 115, 112, 108, 105, /* 7088-7095 */
102,  99, 103, 107, 111, 116, 120, 122, /* 7096-7103 */
119, 117, 115, 113, 111, 113, 118, 122, /* 7104-7111 */
127, 131, 133, 131, 128, 128, 132, 136, /* 7112-7119 */
135, 131, 129, 131, 134, 137, 140, 143, /* 7120-7127 */
144, 141, 137, 135, 138, 140, 143, 145, /* 7128-7135 */
147, 144, 139, 134, 130, 125, 122, 125, /* 7136-7143 */
129, 130, 127, 124, 121, 116, 112, 108, /* 7144-7151 */
105, 101,  98,  96,  94,  92,  91,  92, /* 7152-7159 */
 98, 103, 109, 114, 120, 121, 119, 118, /* 7160-7167 */
117, 116, 115, 114, 113, 114, 120, 125, /* 7168-7175 */
130, 136, 140, 141, 138, 137, 135, 133, /* 7176-7183 */
132, 130, 128, 129, 134, 139, 144, 148, /* 7184-7191 */
152, 152, 149, 146, 144, 141, 140, 143, /* 7192-7199 */
147, 149, 145, 142, 140, 137, 134, 132, /* 7200-7207 */
129, 127, 125, 123, 122, 120, 119, 120, /* 7208-7215 */
126, 131, 133, 132, 131, 134, 140, 144, /* 7216-7223 */
149, 154, 156, 154, 151, 150, 154, 157, /* 7224-7231 */
156, 152, 148, 149, 154, 157, 154, 151, /* 7232-7239 */
147, 148, 149, 148, 142, 136, 135, 136, /* 7240-7247 */
137, 134, 128, 124, 119, 115, 112, 114, /* 7248-7255 */
117, 120, 122, 125, 127, 130, 132, 134, /* 7256-7263 */
136, 138, 140, 141, 142, 143, 143, 144, /* 7264-7271 */
144, 144, 141, 134, 128, 122, 116, 110, /* 7272-7279 */
110, 112, 113, 114, 116, 115, 109, 105, /* 7280-7287 */
100,  96,  92,  93,  96,  99, 102, 105, /* 7288-7295 */
108, 104, 101,  98,  95,  92,  93,  98, /* 7296-7303 */
101, 105, 109, 113, 111, 109, 106, 103, /* 7304-7311 */
101, 101, 105, 110, 111, 108, 106, 109, /* 7312-7319 */
114, 118, 117, 114, 114, 117, 122, 125, /* 7320-7327 */
124, 123, 122, 121, 119, 120, 124, 127, /* 7328-7335 */
125, 121, 120, 123, 128, 129, 126, 124, /* 7336-7343 */
125, 129, 133, 132, 129, 127, 130, 134, /* 7344-7351 */
137, 134, 132, 129, 127, 124, 125, 130, /* 7352-7359 */
134, 138, 141, 145, 149, 152, 155, 159, /* 7360-7367 */
162, 163, 158, 154, 153, 155, 157, 158, /* 7368-7375 */
160, 161, 156, 151, 146, 141, 136, 131, /* 7376-7383 */
127, 122, 121, 124, 127, 130, 133, 136, /* 7384-7391 */
133, 129, 127, 130, 133, 136, 139, 142, /* 7392-7399 */
141, 137, 133, 129, 125, 122, 124, 127, /* 7400-7407 */
129, 125, 122, 119, 116, 113, 111, 108, /* 7408-7415 */
106, 104, 102, 102, 103, 103, 104, 104, /* 7416-7423 */
103, 104, 109, 115, 117, 116, 115, 114, /* 7424-7431 */
114, 113, 113, 112, 112, 112, 112, 114, /* 7432-7439 */
121, 127, 134, 140, 146, 147, 146, 145, /* 7440-7447 */
143, 142, 141, 146, 151, 155, 159, 163, /* 7448-7455 */
163, 160, 158, 155, 153, 150, 147, 144, /* 7456-7463 */
141, 138, 136, 134, 132, 130, 131, 137, /* 7464-7471 */
141, 142, 139, 139, 142, 146, 150, 148, /* 7472-7479 */
145, 145, 150, 153, 157, 160, 163, 166, /* 7480-7487 */
168, 171, 172, 173, 174, 168, 162, 157, /* 7488-7495 */
151, 145, 142, 144, 144, 145, 145, 146, /* 7496-7503 */
141, 136, 130, 125, 119, 116, 118, 121, /* 7504-7511 */
121, 117, 115, 115, 118, 119, 115, 109, /* 7512-7519 */
105, 101,  97,  94,  97, 100, 103, 107, /* 7520-7527 */
110, 113, 116, 118, 116, 112, 108, 105, /* 7528-7535 */
101, 107, 123, 133, 143, 150, 157, 162, /* 7536-7543 */
167, 170, 167, 162, 158, 152, 147, 142, /* 7544-7551 */
137, 131, 128, 130, 131, 132, 132, 133, /* 7552-7559 */
129, 126, 126, 123, 120, 118, 119, 121, /* 7560-7567 */
122, 123, 125, 124, 121, 119, 119, 121, /* 7568-7575 */
122, 119, 117, 114, 112, 111, 111, 111, /* 7576-7583 */
110, 111, 113, 114, 116, 117, 119, 117, /* 7584-7591 */
115, 113, 115, 117, 119, 122, 124, 123, /* 7592-7599 */
121, 119, 117, 115, 113, 112, 110, 109, /* 7600-7607 */
108, 107, 108, 110, 114, 118, 121, 124, /* 7608-7615 */
124, 123, 123, 126, 129, 132, 131, 131, /* 7616-7623 */
131, 134, 137, 140, 142, 144, 147, 149, /* 7624-7631 */
150, 152, 154, 154, 151, 148, 147, 147, /* 7632-7639 */
148, 149, 150, 150, 151, 151, 151, 148, /* 7640-7647 */
144, 140, 136, 132, 130, 131, 132, 130, /* 7648-7655 */
127, 124, 121, 119, 117, 115, 112, 111, /* 7656-7663 */
109, 108, 107, 106, 105, 106, 110, 113, /* 7664-7671 */
115, 115, 116, 117, 118, 119, 122, 125, /* 7672-7679 */
128, 130, 133, 135, 137, 139, 138, 136, /* 7680-7687 */
134, 131, 129, 127, 125, 123, 123, 125, /* 7688-7695 */
127, 128, 126, 125, 123, 122, 120, 119, /* 7696-7703 */
118, 117, 117, 116, 116, 120, 123, 127, /* 7704-7711 */
131, 135, 136, 135, 134, 137, 140, 142, /* 7712-7719 */
141, 140, 138, 137, 135, 136, 138, 141, /* 7720-7727 */
140, 138, 137, 139, 141, 143, 145, 147, /* 7728-7735 */
148, 145, 142, 142, 144, 145, 146, 147, /* 7736-7743 */
148, 146, 142, 139, 136, 133, 131, 133, /* 7744-7751 */
134, 135, 136, 137, 135, 132, 129, 127, /* 7752-7759 */
124, 121, 122, 124, 124, 123, 123, 122, /* 7760-7767 */
120, 118, 118, 119, 120, 121, 122, 123, /* 7768-7775 */
124, 126, 125, 122, 119, 117, 114, 111, /* 7776-7783 */
112, 113, 115, 113, 111, 109, 107, 105, /* 7784-7791 */
105, 108, 110, 113, 116, 118, 121, 123, /* 7792-7799 */
125, 124, 122, 121, 119, 118, 117, 115, /* 7800-7807 */
113, 113, 112, 110, 112, 116, 119, 122, /* 7808-7815 */
126, 129, 132, 135, 137, 135, 133, 132, /* 7816-7823 */
130, 128, 127, 125, 124, 122, 121, 120, /* 7824-7831 */
123, 126, 129, 132, 135, 137, 140, 143, /* 7832-7839 */
145, 147, 149, 147, 144, 142, 143, 145, /* 7840-7847 */
145, 142, 138, 138, 139, 139, 138, 134, /* 7848-7855 */
132, 134, 137, 139, 141, 142, 142, 137, /* 7856-7863 */
133, 129, 126, 122, 118, 115, 113, 113, /* 7864-7871 */
115, 116, 114, 112, 111, 114, 116, 117, /* 7872-7879 */
115, 113, 112, 111, 110, 112, 115, 118, /* 7880-7887 */
121, 123, 126, 129, 132, 132, 130, 128, /* 7888-7895 */
127, 126, 124, 123, 121, 120, 123, 126, /* 7896-7903 */
127, 126, 125, 124, 123, 122, 121, 120, /* 7904-7911 */
119, 122, 126, 129, 132, 135, 139, 141, /* 7912-7919 */
144, 145, 143, 141, 142, 144, 146, 148, /* 7920-7927 */
149, 150, 148, 145, 142, 139, 136, 133, /* 7928-7935 */
131, 129, 129, 131, 133, 134, 136, 137, /* 7936-7943 */
135, 133, 131, 133, 135, 138, 141, 144, /* 7944-7951 */
146, 147, 146, 143, 138, 135, 134, 134, /* 7952-7959 */
133, 129, 125, 121, 118, 114, 114, 115, /* 7960-7967 */
117, 115, 111, 110, 112, 114, 114, 113, /* 7968-7975 */
111, 111, 114, 116, 116, 114, 113, 111, /* 7976-7983 */
109, 109, 107, 106, 107, 107, 106, 106, /* 7984-7991 */
107, 107, 109, 114, 118, 119, 119, 120, /* 7992-7999 */
124, 128, 133, 136, 140, 141, 140, 139, /* 8000-8007 */
141, 144, 146, 149, 151, 152, 151, 148, /* 8008-8015 */
146, 144, 141, 141, 142, 144, 143, 140, /* 8016-8023 */
138, 136, 134, 132, 134, 136, 138, 139, /* 8024-8031 */
141, 142, 139, 137, 137, 139, 140, 141, /* 8032-8039 */
143, 146, 149, 151, 152, 153, 152, 152, /* 8040-8047 */
151, 150, 146, 141, 136, 134, 134, 133, /* 8048-8055 */
128, 124, 120, 116, 112, 109, 105, 102, /* 8056-8063 */
102, 104, 106, 105, 103, 102, 104, 106, /* 8064-8071 */
108, 107, 105, 104, 103, 102, 103, 107, /* 8072-8079 */
111, 115, 118, 121, 121, 120, 119, 118, /* 8080-8087 */
117, 118, 121, 124, 127, 130, 133, 135, /* 8088-8095 */
138, 140, 142, 144, 145, 142, 140, 137, /* 8096-8103 */
134, 132, 129, 127, 124, 122, 120, 119, /* 8104-8111 */
117, 116, 114, 113, 113, 114, 117, 121, /* 8112-8119 */
124, 128, 131, 134, 138, 140, 139, 137, /* 8120-8127 */
136, 139, 140, 142, 145, 148, 151, 154, /* 8128-8135 */
155, 153, 148, 144, 143, 143, 143, 142, /* 8136-8143 */
142, 142, 141, 141, 138, 133, 130, 129, /* 8144-8151 */
129, 129, 129, 129, 129, 130, 130, 130, /* 8152-8159 */
130, 131, 128, 124, 121, 117, 113, 110, /* 8160-8167 */
111, 111, 113, 114, 116, 118, 120, 122, /* 8168-8175 */
123, 124, 126, 127, 128, 129, 126, 123, /* 8176-8183 */
120, 117, 114, 113, 115, 116, 118, 120, /* 8184-8191 */
121, 120, 117, 115, 113, 111, 109, 108, /* 8192-8199 */
106, 105, 104, 103, 104, 108, 112, 115, /* 8200-8207 */
119, 122, 125, 127, 129, 128, 127, 127, /* 8208-8215 */
130, 132, 132, 130, 129, 130, 132, 133, /* 8216-8223 */
136, 139, 142, 141, 139, 137, 135, 132, /* 8224-8231 */
131, 132, 132, 131, 128, 126, 127, 129, /* 8232-8239 */
129, 127, 126, 125, 127, 129, 131, 132, /* 8240-8247 */
134, 136, 138, 139, 140, 142, 143, 144, /* 8248-8255 */
145, 144, 141, 138, 137, 138, 138, 137, /* 8256-8263 */
134, 132, 133, 134, 135, 136, 137, 138, /* 8264-8271 */
139, 140, 141, 141, 142, 140, 137, 134, /* 8272-8279 */
135, 135, 136, 136, 137, 136, 133, 130, /* 8280-8287 */
129, 130, 130, 131, 132, 133, 133, 134, /* 8288-8295 */
134, 131, 128, 126, 127, 128, 129, 129, /* 8296-8303 */
130, 128, 125, 123, 123, 124, 125, 122, /* 8304-8311 */
119, 117, 115, 112, 111, 111, 111, 114, /* 8312-8319 */
116, 118, 119, 120, 121, 118, 116, 116, /* 8320-8327 */
117, 118, 120, 121, 123, 125, 127, 128, /* 8328-8335 */
126, 124, 122, 120, 118, 116, 114, 113, /* 8336-8343 */
113, 115, 118, 118, 116, 115, 115, 114, /* 8344-8351 */
113, 112, 112, 112, 113, 113, 115, 119, /* 8352-8359 */
123, 127, 130, 134, 137, 141, 143, 146, /* 8360-8367 */
149, 150, 148, 147, 145, 143, 141, 142, /* 8368-8375 */
144, 145, 147, 148, 150, 151, 152, 152, /* 8376-8383 */
149, 147, 144, 141, 139, 138, 139, 140, /* 8384-8391 */
141, 142, 143, 140, 138, 135, 133, 130, /* 8392-8399 */
130, 131, 132, 131, 128, 126, 124, 123, /* 8400-8407 */
122, 122, 122, 122, 120, 119, 117, 115, /* 8408-8415 */
113, 114, 116, 118, 118, 117, 116, 115, /* 8416-8423 */
114, 114, 117, 120, 121, 121, 120, 122, /* 8424-8431 */
125, 127, 127, 126, 125, 124, 124, 123, /* 8432-8439 */
122, 121, 121, 120, 119, 119, 119, 119, /* 8440-8447 */
123, 126, 129, 129, 129, 129, 129, 129, /* 8448-8455 */
130, 134, 137, 140, 142, 145, 145, 143, /* 8456-8463 */
143, 145, 147, 148, 150, 152, 151, 149, /* 8464-8471 */
146, 146, 147, 148, 149, 149, 150, 150, /* 8472-8479 */
151, 150, 146, 143, 141, 141, 141, 139, /* 8480-8487 */
135, 132, 132, 132, 132, 129, 125, 123, /* 8488-8495 */
124, 124, 123, 120, 118, 120, 123, 124, /* 8496-8503 */
123, 119, 117, 116, 116, 116, 112, 109, /* 8504-8511 */
107, 104, 102, 100,  98,  96,  98, 100, /* 8512-8519 */
102, 101, 100, 100,  99,  98, 100, 103, /* 8520-8527 */
106, 107, 107, 106, 108, 112, 115, 114, /* 8528-8535 */
113, 114, 117, 121, 123, 122, 122, 122, /* 8536-8543 */
121, 121, 120, 120, 119, 119, 119, 120, /* 8544-8551 */
123, 127, 128, 128, 128, 128, 127, 127, /* 8552-8559 */
130, 133, 136, 139, 142, 145, 147, 149, /* 8560-8567 */
150, 148, 146, 144, 143, 141, 142, 143, /* 8568-8575 */
144, 143, 140, 140, 141, 143, 142, 140, /* 8576-8583 */
138, 136, 134, 132, 133, 134, 135, 134, /* 8584-8591 */
133, 134, 137, 140, 141, 142, 142, 140, /* 8592-8599 */
137, 134, 131, 128, 125, 122, 120, 118, /* 8600-8607 */
120, 122, 122, 119, 118, 116, 115, 114, /* 8608-8615 */
113, 112, 111, 113, 116, 118, 118, 117, /* 8616-8623 */
116, 116, 115, 115, 114, 114, 114, 114, /* 8624-8631 */
115, 115, 116, 117, 121, 125, 129, 132, /* 8632-8639 */
136, 139, 142, 145, 148, 150, 152, 150, /* 8640-8647 */
148, 147, 149, 150, 150, 147, 145, 144, /* 8648-8655 */
145, 146, 147, 148, 148, 149, 149, 149, /* 8656-8663 */
145, 142, 139, 136, 133, 130, 127, 124, /* 8664-8671 */
125, 126, 127, 128, 129, 130, 127, 125, /* 8672-8679 */
124, 125, 126, 128, 130, 133, 133, 130, /* 8680-8687 */
129, 128, 128, 128, 128, 128, 128, 128, /* 8688-8695 */
127, 127, 127, 128, 125, 121, 118, 118, /* 8696-8703 */
118, 118, 115, 112, 109, 107, 104, 102, /* 8704-8711 */
100,  98,  99, 102, 104, 106, 109, 110, /* 8712-8719 */
109, 108, 107, 107, 107, 109, 112, 115, /* 8720-8727 */
115, 115, 114, 114, 113, 114, 117, 120, /* 8728-8735 */
124, 127, 130, 133, 135, 138, 137, 136, /* 8736-8743 */
135, 134, 132, 131, 130, 128, 127, 126, /* 8744-8751 */
125, 124, 123, 123, 125, 128, 131, 134, /* 8752-8759 */
137, 139, 138, 137, 136, 136, 135, 136, /* 8760-8767 */
138, 141, 140, 139, 137, 136, 135, 135, /* 8768-8775 */
139, 142, 146, 148, 150, 151, 152, 152, /* 8776-8783 */
150, 146, 144, 143, 144, 144, 140, 137, /* 8784-8791 */
135, 132, 129, 127, 124, 122, 123, 125, /* 8792-8799 */
126, 125, 123, 121, 120, 119, 119, 121, /* 8800-8807 */
124, 126, 128, 130, 130, 128, 127, 127, /* 8808-8815 */
126, 125, 128, 130, 132, 135, 137, 139, /* 8816-8823 */
141, 143, 144, 145, 147, 148, 149, 148, /* 8824-8831 */
146, 142, 141, 141, 142, 140, 136, 133, /* 8832-8839 */
130, 128, 125, 126, 127, 128, 129, 130, /* 8840-8847 */
131, 132, 133, 134, 134, 135, 136, 136, /* 8848-8855 */
137, 137, 137, 137, 137, 137, 137, 136, /* 8856-8863 */
136, 133, 128, 125, 123, 121, 119, 120, /* 8864-8871 */
120, 118, 114, 110, 108, 108, 108, 109, /* 8872-8879 */
109, 110, 111, 111, 112, 110, 107, 105, /* 8880-8887 */
107, 108, 109, 110, 112, 113, 114, 116, /* 8888-8895 */
115, 112, 110, 108, 106, 105, 103, 101, /* 8896-8903 */
100,  99,  98,  99,  99,  99, 102, 106, /* 8904-8911 */
109, 113, 117, 120, 120, 120, 122, 125, /* 8912-8919 */
129, 132, 135, 138, 140, 142, 143, 143, /* 8920-8927 */
141, 140, 140, 141, 141, 139, 137, 137, /* 8928-8935 */
138, 138, 137, 136, 134, 135, 136, 137, /* 8936-8943 */
138, 139, 139, 137, 136, 134, 133, 132, /* 8944-8951 */
132, 134, 134, 133, 132, 131, 132, 135, /* 8952-8959 */
138, 140, 143, 143, 141, 139, 138, 139, /* 8960-8967 */
138, 136, 134, 133, 133, 133, 133, 131, /* 8968-8975 */
130, 129, 130, 131, 130, 129, 127, 126, /* 8976-8983 */
125, 125, 126, 127, 128, 127, 126, 127, /* 8984-8991 */
128, 130, 131, 132, 134, 133, 132, 132, /* 8992-8999 */
132, 131, 130, 129, 129, 128, 128, 127, /* 9000-9007 */
129, 131, 132, 132, 132, 131, 131, 131, /* 9008-9015 */
131, 133, 135, 137, 139, 140, 142, 143, /* 9016-9023 */
144, 146, 146, 147, 148, 149, 148, 146, /* 9024-9031 */
144, 143, 144, 144, 144, 144, 144, 143, /* 9032-9039 */
143, 143, 143, 143, 142, 141, 141, 139, /* 9040-9047 */
136, 133, 130, 128, 127, 126, 125, 123, /* 9048-9055 */
120, 118, 115, 112, 109, 108, 105, 103, /* 9056-9063 */
103, 101, 100, 102, 104, 105, 107, 109, /* 9064-9071 */
111, 110, 110, 110, 109, 109, 109, 109, /* 9072-9079 */
109, 111, 113, 115, 117, 120, 122, 124, /* 9080-9087 */
126, 126, 126, 126, 127, 129, 131, 133, /* 9088-9095 */
134, 135, 137, 138, 139, 140, 141, 140, /* 9096-9103 */
138, 136, 136, 137, 137, 135, 133, 132, /* 9104-9111 */
132, 133, 133, 131, 129, 127, 126, 124, /* 9112-9119 */
123, 122, 120, 121, 123, 124, 125, 127, /* 9120-9127 */
128, 129, 130, 130, 129, 128, 128, 129, /* 9128-9135 */
130, 131, 132, 132, 130, 128, 127, 127, /* 9136-9143 */
127, 127, 126, 125, 123, 121, 119, 119, /* 9144-9151 */
120, 120, 119, 117, 116, 117, 119, 120, /* 9152-9159 */
121, 122, 122, 121, 120, 119, 118, 117, /* 9160-9167 */
116, 116, 115, 115, 114, 114, 114, 113, /* 9168-9175 */
115, 117, 120, 120, 120, 120, 123, 126, /* 9176-9183 */
128, 128, 128, 128, 128, 128, 128, 128, /* 9184-9191 */
128, 128, 128, 128, 130, 132, 134, 134, /* 9192-9199 */
134, 135, 137, 139, 139, 138, 138, 139, /* 9200-9207 */
141, 142, 144, 145, 146, 147, 148, 149, /* 9208-9215 */
149, 150, 149, 147, 145, 145, 145, 145, /* 9216-9223 */
142, 140, 139, 139, 139, 138, 136, 133, /* 9224-9231 */
131, 129, 126, 126, 126, 126, 127, 129, /* 9232-9239 */
129, 126, 123, 122, 123, 123, 122, 120, /* 9240-9247 */
118, 118, 119, 120, 120, 121, 122, 123, /* 9248-9255 */
123, 124, 122, 120, 120, 121, 122, 121, /* 9256-9263 */
119, 118, 119, 120, 120, 119, 118, 117, /* 9264-9271 */
119, 120, 122, 124, 125, 125, 124, 123, /* 9272-9279 */
124, 126, 126, 125, 124, 124, 123, 121, /* 9280-9287 */
122, 124, 125, 127, 128, 130, 131, 132, /* 9288-9295 */
133, 132, 130, 130, 131, 132, 132, 130, /* 9296-9303 */
129, 128, 127, 126, 127, 128, 129, 127, /* 9304-9311 */
126, 125, 125, 124, 124, 126, 127, 129, /* 9312-9319 */
130, 131, 131, 129, 129, 130, 132, 134, /* 9320-9327 */
137, 139, 141, 142, 142, 141, 141, 140, /* 9328-9335 */
137, 134, 132, 132, 131, 131, 131, 131, /* 9336-9343 */
129, 127, 124, 122, 120, 119, 119, 120, /* 9344-9351 */
120, 118, 117, 117, 118, 119, 119, 118, /* 9352-9359 */
117, 116, 115, 114, 113, 113, 114, 116, /* 9360-9367 */
119, 121, 123, 125, 126, 126, 125, 127, /* 9368-9375 */
129, 131, 130, 130, 130, 131, 133, 134, /* 9376-9383 */
133, 132, 131, 131, 130, 131, 133, 134, /* 9384-9391 */
133, 132, 132, 131, 130, 130, 132, 134, /* 9392-9399 */
134, 133, 133, 134, 135, 137, 138, 139, /* 9400-9407 */
140, 139, 138, 138, 139, 140, 140, 141, /* 9408-9415 */
142, 142, 142, 144, 144, 143, 142, 143, /* 9416-9423 */
142, 141, 137, 134, 131, 128, 126, 124, /* 9424-9431 */
124, 125, 125, 125, 125, 125, 126, 126, /* 9432-9439 */
126, 127, 127, 127, 128, 126, 124, 122, /* 9440-9447 */
122, 123, 123, 121, 119, 118, 116, 115, /* 9448-9455 */
113, 112, 112, 112, 111, 111, 111, 110, /* 9456-9463 */
111, 113, 116, 118, 121, 123, 124, 124, /* 9464-9471 */
124, 124, 124, 124, 126, 128, 130, 132, /* 9472-9479 */
134, 135, 137, 139, 140, 141, 142, 142, /* 9480-9487 */
140, 139, 139, 140, 141, 141, 142, 142, /* 9488-9495 */
139, 138, 137, 138, 138, 137, 134, 133, /* 9496-9503 */
131, 129, 127, 126, 124, 123, 122, 123, /* 9504-9511 */
123, 124, 123, 124, 125, 125, 124, 122, /* 9512-9519 */
121, 122, 123, 124, 122, 121, 122, 123, /* 9520-9527 */
124, 124, 123, 122, 122, 121, 120, 119, /* 9528-9535 */
119, 119, 121, 123, 123, 123, 122, 122, /* 9536-9543 */
122, 121, 121, 121, 121, 121, 121, 122, /* 9544-9551 */
122, 123, 123, 124, 124}; /* 9552-9556 */

