#pragma once

#define WHITE 0xFFFFFF
#define BLACK 0x000000
#define _RED_  0xFF0000
#define GREEN 0x00FF00
#define _BLUE  0x0000FF
#define LGREY 0xBFBFBF
#define DGREY 0x5F5F5F

#define YELLW 0xFFFF00
#define LBLUE 0x00FFFF
#define _PINK 0xFF80FF
#define VIOLT 0x8080FF
#define LGREN 0x80FF00
#define LPECH 0xF78D4C
#define DPECH 0xC96830
#define RPECH 0xF25427

///////////////////////////////
///////////////////////////////
// Tiles
const int TrapLine[9][9] =
{
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {_PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK},
   {_PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK}
};
const int FruitIcon[9][9] =
{
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, YELLW, YELLW, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK, BLACK},
   {BLACK, BLACK, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK, BLACK},
   {BLACK, BLACK, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK, BLACK},
   {BLACK, BLACK, BLACK, YELLW, YELLW, YELLW, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK}
};
const int PowerUpIcon[9][9] =
{
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, _RED_, _RED_, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, _RED_, _RED_, _RED_, _RED_, _RED_, BLACK, BLACK},
   {BLACK, BLACK, _RED_, _RED_, _RED_, _RED_, _RED_, BLACK, BLACK},
   {BLACK, BLACK, _RED_, _RED_, _RED_, _RED_, _RED_, BLACK, BLACK},
   {BLACK, BLACK, BLACK, _RED_, _RED_, _RED_, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK},
   {BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK}
};
const int HoneyDropIcon[3][3] =
{
   {BLACK, YELLW, BLACK},
   {YELLW, YELLW, YELLW},
   {BLACK, YELLW, BLACK}
};
///////////////////////////////
///////////////////////////////
// PacMan
const int BuzzyIcon[2][9][9] =
{
{
   {BLACK, BLACK, BLACK, YELLW, YELLW, YELLW, BLACK, BLACK, BLACK},
   {BLACK, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK},
   {BLACK, YELLW, YELLW, YELLW, YELLW, BLACK, YELLW, YELLW, BLACK},
   {YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW},
   {YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW},
   {YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW},
   {BLACK, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK},
   {BLACK, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK},
   {BLACK, BLACK, BLACK, YELLW, YELLW, YELLW, BLACK, BLACK, BLACK}
},
{
   {BLACK, BLACK, BLACK, YELLW, YELLW, YELLW, BLACK, BLACK, BLACK},
   {BLACK, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK},
   {BLACK, YELLW, YELLW, YELLW, YELLW, BLACK, YELLW, YELLW, BLACK},
   {YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK, BLACK},
   {YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK, BLACK},
   {YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK, BLACK},
   {BLACK, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK},
   {BLACK, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, YELLW, BLACK},
   {BLACK, BLACK, BLACK, YELLW, YELLW, YELLW, BLACK, BLACK, BLACK}
},

};

///////////////////////////////
///////////////////////////////
// Ghosts
const int VioletGhost[2][9][9] =
{
{
   {BLACK, BLACK, BLACK, VIOLT, VIOLT, VIOLT, BLACK, BLACK, BLACK},
   {BLACK, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, BLACK},
   {BLACK, VIOLT, WHITE, BLACK, VIOLT, WHITE, BLACK, VIOLT, BLACK},
   {BLACK, VIOLT, WHITE, WHITE, VIOLT, WHITE, WHITE, VIOLT, BLACK},
   {BLACK, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT},
   {VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT},
   {VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT},
   {VIOLT, VIOLT, BLACK, VIOLT, VIOLT, VIOLT, BLACK, VIOLT, VIOLT},
   {VIOLT, BLACK, BLACK, BLACK, VIOLT, BLACK, BLACK, BLACK, VIOLT}
},
{
   {BLACK, BLACK, BLACK, VIOLT, VIOLT, VIOLT, BLACK, BLACK, BLACK},
   {BLACK, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, BLACK},
   {BLACK, VIOLT, BLACK, WHITE, VIOLT, BLACK, WHITE, VIOLT, BLACK},
   {BLACK, VIOLT, WHITE, WHITE, VIOLT, WHITE, WHITE, VIOLT, VIOLT},
   {BLACK, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT},
   {VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT},
   {VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT},
   {VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT, VIOLT},
   {VIOLT, BLACK, BLACK, BLACK, VIOLT, BLACK, BLACK, BLACK, VIOLT}
},

};
const int BlueGhost[2][9][9] =
{
{
   {BLACK, BLACK, BLACK, LBLUE, LBLUE, LBLUE, BLACK, BLACK, BLACK},
   {BLACK, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, BLACK},
   {BLACK, LBLUE, WHITE, BLACK, LBLUE, WHITE, BLACK, LBLUE, BLACK},
   {BLACK, LBLUE, WHITE, WHITE, LBLUE, WHITE, WHITE, LBLUE, BLACK},
   {BLACK, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE},
   {LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE},
   {LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE},
   {LBLUE, LBLUE, BLACK, LBLUE, LBLUE, LBLUE, BLACK, LBLUE, LBLUE},
   {LBLUE, BLACK, BLACK, BLACK, LBLUE, BLACK, BLACK, BLACK, LBLUE}
},
{
   {BLACK, BLACK, BLACK, LBLUE, LBLUE, LBLUE, BLACK, BLACK, BLACK},
   {BLACK, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, BLACK},
   {BLACK, LBLUE, BLACK, WHITE, LBLUE, BLACK, WHITE, LBLUE, BLACK},
   {BLACK, LBLUE, WHITE, WHITE, LBLUE, WHITE, WHITE, LBLUE, LBLUE},
   {BLACK, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE},
   {LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE},
   {LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE},
   {LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE, LBLUE},
   {LBLUE, BLACK, BLACK, BLACK, LBLUE, BLACK, BLACK, BLACK, LBLUE}
},

};
const int PinkGhost[2][9][9] =
{
{
   {BLACK, BLACK, BLACK, _PINK, _PINK, _PINK, BLACK, BLACK, BLACK},
   {BLACK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, BLACK},
   {BLACK, _PINK, WHITE, BLACK, _PINK, WHITE, BLACK, _PINK, BLACK},
   {BLACK, _PINK, WHITE, WHITE, _PINK, WHITE, WHITE, _PINK, BLACK},
   {BLACK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK},
   {_PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK},
   {_PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK},
   {_PINK, _PINK, BLACK, _PINK, _PINK, _PINK, BLACK, _PINK, _PINK},
   {_PINK, BLACK, BLACK, BLACK, _PINK, BLACK, BLACK, BLACK, _PINK}
},
{
   {BLACK, BLACK, BLACK, _PINK, _PINK, _PINK, BLACK, BLACK, BLACK},
   {BLACK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, BLACK},
   {BLACK, _PINK, BLACK, WHITE, _PINK, BLACK, WHITE, _PINK, BLACK},
   {BLACK, _PINK, WHITE, WHITE, _PINK, WHITE, WHITE, _PINK, _PINK},
   {BLACK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK},
   {_PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK},
   {_PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK},
   {_PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK, _PINK},
   {_PINK, BLACK, BLACK, BLACK, _PINK, BLACK, BLACK, BLACK, _PINK}
},

};
const int GreenGhost[2][9][9] =
{
{
   {BLACK, BLACK, BLACK, LGREN, LGREN, LGREN, BLACK, BLACK, BLACK},
   {BLACK, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, BLACK},
   {BLACK, LGREN, WHITE, BLACK, LGREN, WHITE, BLACK, LGREN, BLACK},
   {BLACK, LGREN, WHITE, WHITE, LGREN, WHITE, WHITE, LGREN, BLACK},
   {BLACK, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN},
   {LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN},
   {LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN},
   {LGREN, LGREN, BLACK, LGREN, LGREN, LGREN, BLACK, LGREN, LGREN},
   {LGREN, BLACK, BLACK, BLACK, LGREN, BLACK, BLACK, BLACK, LGREN}
},
{
   {BLACK, BLACK, BLACK, LGREN, LGREN, LGREN, BLACK, BLACK, BLACK},
   {BLACK, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, BLACK},
   {BLACK, LGREN, BLACK, WHITE, LGREN, BLACK, WHITE, LGREN, BLACK},
   {BLACK, LGREN, WHITE, WHITE, LGREN, WHITE, WHITE, LGREN, LGREN},
   {BLACK, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN},
   {LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN},
   {LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN},
   {LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN, LGREN},
   {LGREN, BLACK, BLACK, BLACK, LGREN, BLACK, BLACK, BLACK, LGREN}
},

};
#define MAZE_NUM_ROW 40
#define MAZE_NUM_COL 42
#define MAZE_SCALE 3

#define GAME_PAUSED 0
#define GAME_RUNNING 1
#define GAME_OVER 2
#define NUM_GHOSTS 4
#define NUM_ALL_SPRITES (NUM_GHOSTS + 1)


#define BLUE_SQUARE 1
#define HONEYDROP_SQUARE 2
#define PWRUP_SQUARE 3
#define GHOST_ICON 4
#define BUZZY_ICON 5
#define TRAP_LINE 6

///////////////////////////////
///////////////////////////////
// Maze
// The maze is a scaled down version of the LCD display
// Each element in the maze is really a 3x3 segment of the LCD
// This must be taken into account when drawing the maze
const char gCnstMaze[MAZE_NUM_ROW][MAZE_NUM_COL] =
{
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,2,0,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
1,0,2,0,1,1,1,1,1,0,0,0,1,1,1,1,1,0,2,0,0,0,0,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,2,0,1,
1,0,0,0,1,1,1,1,1,0,2,0,1,1,1,1,1,0,0,0,2,0,2,0,1,1,1,1,1,1,0,2,0,1,1,1,1,1,0,0,0,1,
1,0,3,0,1,1,1,1,1,0,0,0,1,1,1,1,1,0,2,0,0,0,0,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,3,0,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,0,2,0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
1,0,2,0,1,1,1,1,1,0,2,0,1,1,1,1,1,0,2,0,1,0,2,0,1,1,1,1,1,1,0,2,0,1,1,1,1,1,0,2,0,1,
1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,
1,0,2,0,2,0,2,0,2,0,2,0,1,1,1,1,1,0,2,0,1,0,2,0,1,1,1,1,1,1,0,2,0,2,0,2,0,2,0,2,0,1,
1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,
1,1,1,1,1,1,1,1,1,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,2,0,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0,0,0,1,0,2,0,2,0,2,0,4,0,2,0,2,0,2,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,2,0,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0,0,0,1,0,2,0,1,1,1,6,6,6,1,1,1,0,2,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,0,0,0,0,0,0,0,1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,4,0,4,0,4,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,1,0,0,0,1,0,2,0,1,0,0,0,0,0,0,0,1,0,0,0,1,1,0,2,0,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0,2,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,2,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0,0,0,1,0,2,0,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,2,0,1,1,1,1,1,1,1,1,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,5,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,2,0,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
1,0,3,0,1,1,1,1,1,0,2,0,1,1,1,1,1,0,0,0,1,1,0,2,0,1,1,1,1,1,0,2,0,1,1,1,1,1,0,2,0,1,
1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,2,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,
1,0,2,0,2,0,2,0,1,0,2,0,2,0,2,0,1,0,0,0,1,1,0,2,0,2,0,2,0,1,0,2,0,2,0,2,0,1,0,3,0,1,
1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,2,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,
1,1,1,1,1,0,2,0,1,0,2,0,1,0,2,0,1,0,0,0,1,1,1,1,1,1,0,0,0,1,0,2,0,1,0,2,0,1,0,2,0,1,
1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,
1,0,2,0,2,0,2,0,2,0,2,0,1,0,2,0,2,0,2,0,1,1,0,2,0,2,0,2,0,2,0,2,0,1,0,2,0,2,0,2,0,1,
1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,
1,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,1,1,1,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,1,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,3,0,2,0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
};

